/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.glaciers.model.IToolProducer;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import java.awt.geom.Point2D;

public class TrashCanDelegate {
    private PNode _trashCanNode;
    private IToolProducer _toolProducer;

    public TrashCanDelegate(PNode pNode, IToolProducer iToolProducer) {
        this._trashCanNode = pNode;
        this._toolProducer = iToolProducer;
    }

    public boolean isInTrash(Point2D point2D) {
        return this._trashCanNode.getGlobalFullBounds().contains(point2D);
    }

    public void delete(final AbstractToolNode abstractToolNode, Point2D point2D) {
        assert (this.isInTrash(point2D));
        PTransformActivity pTransformActivity = abstractToolNode.animateToPositionScaleRotation(point2D.getX(), point2D.getY(), 0.1, abstractToolNode.getRotation(), 300L);
        PActivity pActivity = new PActivity(-1L){

            protected void activityStep(long l) {
                TrashCanDelegate.this._toolProducer.removeTool(abstractToolNode.getTool());
                this.terminate();
            }
        };
        this._trashCanNode.addActivity(pActivity);
        pActivity.startAfter(pTransformActivity);
    }
}

