/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ToolTipNode;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.IToolProducer;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.BoreholeDrillIconNode;
import edu.colorado.phet.glaciers.view.tools.GPSReceiverIconNode;
import edu.colorado.phet.glaciers.view.tools.GlacialBudgetMeterIconNode;
import edu.colorado.phet.glaciers.view.tools.IceThicknessToolIconNode;
import edu.colorado.phet.glaciers.view.tools.ThermometerIconNode;
import edu.colorado.phet.glaciers.view.tools.TracerFlagIconNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class ToolboxNode
extends PNode {
    private static final Insets BACKGROUND_INSETS = new Insets(5, 15, 5, 15);
    private static final Color BACKGROUND_COLOR = Color.LIGHT_GRAY;
    private static final Color BACKGROUND_STROKE_COLOR = new Color(82, 126, 90);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(2.0f);
    private static final Font TAB_LABEL_FONT = new PhetFont(12);
    private static final Color TAB_LABEL_COLOR = Color.BLACK;
    private static final Color TAB_COLOR = BACKGROUND_COLOR;
    private static final Color TAB_STROKE_COLOR = BACKGROUND_STROKE_COLOR;
    private static final Stroke TAB_STROKE = BACKGROUND_STROKE;
    private final TrashCanDelegate _trashCanDelegate;

    public ToolboxNode(IToolProducer iToolProducer, GlaciersModelViewTransform glaciersModelViewTransform) {
        ArrayList<ThermometerIconNode> arrayList = new ArrayList<ThermometerIconNode>();
        PNode pNode = new PNode();
        PNode pNode2 = new PNode();
        PNode pNode3 = null;
        ToolboxToolTipNode toolboxToolTipNode = null;
        pNode3 = new ThermometerIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_THERMOMETER, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        pNode3 = new GlacialBudgetMeterIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_GLACIAL_BUDGET_METER, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        pNode3 = new TracerFlagIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_TRACER_FLAG, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        pNode3 = new IceThicknessToolIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_ICE_THICKNESS_TOOL, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        pNode3 = new BoreholeDrillIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_BOREHOLE_DRILL, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        pNode3 = new GPSReceiverIconNode(iToolProducer, glaciersModelViewTransform);
        toolboxToolTipNode = new ToolboxToolTipNode(GlaciersStrings.TOOLTIP_GPS_RECEIVER, pNode3);
        pNode2.addChild(toolboxToolTipNode);
        arrayList.add((ThermometerIconNode)pNode3);
        this._trashCanDelegate = new TrashCanDelegate(this, iToolProducer);
        ToolboxNode.layoutNodes(arrayList, pNode);
        pNode3 = new PPath();
        double d = pNode.getFullBoundsReference().getWidth() + (double)ToolboxNode.BACKGROUND_INSETS.left + (double)ToolboxNode.BACKGROUND_INSETS.right;
        double d2 = pNode.getFullBoundsReference().getHeight() + (double)ToolboxNode.BACKGROUND_INSETS.top + (double)ToolboxNode.BACKGROUND_INSETS.bottom;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d2, 10.0, 10.0);
        ((PPath)pNode3).setPathTo(double_);
        pNode3.setPaint(BACKGROUND_COLOR);
        ((PPath)pNode3).setStroke(BACKGROUND_STROKE);
        ((PPath)pNode3).setStrokePaint(BACKGROUND_STROKE_COLOR);
        PComposite pComposite = new PComposite();
        PText pText = new PText(GlaciersStrings.TITLE_TOOLBOX);
        pText.setFont(TAB_LABEL_FONT);
        pText.setTextPaint(TAB_LABEL_COLOR);
        double d3 = pText.getFullBoundsReference().getWidth() + 10.0;
        double d4 = pText.getFullBoundsReference().getHeight() + 10.0 + 10.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(0.0, 0.0, d3, d4, 10.0, 10.0);
        PPath pPath = new PPath(double_2);
        pPath.setPaint(TAB_COLOR);
        pPath.setStroke(TAB_STROKE);
        pPath.setStrokePaint(TAB_STROKE_COLOR);
        pComposite.addChild(pPath);
        pComposite.addChild(pText);
        pPath.setOffset(0.0, 0.0);
        pText.setOffset(5.0, 5.0);
        this.addChild(pComposite);
        this.addChild(pNode3);
        this.addChild(pNode);
        this.addChild(pNode2);
        pComposite.setOffset(0.0, 0.0);
        pNode3.setOffset(pComposite.getFullBounds().getX(), pComposite.getFullBounds().getMaxY() - 10.0);
        pNode.setOffset(pNode3.getFullBounds().getX() + (double)ToolboxNode.BACKGROUND_INSETS.left, pNode3.getFullBounds().getY() + (double)ToolboxNode.BACKGROUND_INSETS.top);
        this.setPickable(false);
        pNode.setPickable(false);
        pNode3.setPickable(false);
        pNode3.setChildrenPickable(false);
        pComposite.setPickable(false);
        pComposite.setChildrenPickable(false);
    }

    private static void layoutNodes(ArrayList arrayList, PNode pNode) {
        for (PNode pNode2 : arrayList) {
            pNode.addChild(pNode2);
        }
        double d = pNode.getFullBoundsReference().getHeight();
        PNode pNode3 = null;
        for (PNode pNode4 : arrayList) {
            double d2;
            double d3;
            if (pNode3 == null) {
                d3 = 0.0;
                d2 = (d - pNode4.getFullBoundsReference().getHeight()) / 2.0;
            } else {
                d3 = pNode3.getFullBoundsReference().getMaxX() + 15.0;
                d2 = (d - pNode4.getFullBoundsReference().getHeight()) / 2.0;
            }
            pNode4.setOffset(d3, d2);
            pNode3 = pNode4;
        }
    }

    public TrashCanDelegate getTrashCanDelegate() {
        return this._trashCanDelegate;
    }

    private static final class ToolboxToolTipNode
    extends ToolTipNode {
        public ToolboxToolTipNode(String string, PNode pNode) {
            super(string, pNode, 1500);
            this.setLocationStrategy(new ToolTipNode.LeftAlignedAboveMouseCursor());
        }
    }
}

