/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.IceRipple;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class IceRippleNode
extends PComposite {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private final Glacier _glacier;
    private final IceRipple _ripple;
    private final Glacier.GlacierListener _glacierListener;
    private final IceRipple.IceRippleListener _rippleListener;
    private final GlaciersModelViewTransform _mvt;
    private final Point2D _pView;
    private final PPath _topArcNode;
    private final PPath _bottomArcNode;

    public IceRippleNode(IceRipple iceRipple, Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._ripple = iceRipple;
        this._mvt = glaciersModelViewTransform;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                IceRippleNode.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._rippleListener = new IceRipple.IceRippleAdapter(){

            public void positionChanged() {
                IceRippleNode.this.update();
            }
        };
        this._ripple.addIceRippleListener(this._rippleListener);
        Point2D.Double double_ = new Point2D.Double();
        this._pView = new Point2D.Double();
        Dimension dimension = this._ripple.getSize();
        ((Point2D)double_).setLocation(dimension.getWidth(), dimension.getHeight());
        glaciersModelViewTransform.modelToView(double_, this._pView);
        double d = this._pView.getX();
        double d2 = Math.abs(this._pView.getY());
        ((Point2D)double_).setLocation(0.0, this._ripple.getZOffset());
        glaciersModelViewTransform.modelToView(double_, this._pView);
        double d3 = Math.abs(this._pView.getY());
        double d4 = 2.0 * d;
        Arc2D.Double double_2 = new Arc2D.Double(0.0, 0.0, d4, 0.35 * d2, 270.0, 180.0, 0);
        Arc2D.Double double_3 = new Arc2D.Double(0.0, 0.0, d4, 0.65 * d2, 270.0, 180.0, 0);
        this._topArcNode = new PPath(double_2);
        this._topArcNode.setStroke(STROKE);
        this._bottomArcNode = new PPath(double_3);
        this._bottomArcNode.setStroke(STROKE);
        this._bottomArcNode.setOffset(-d4 / 2.0, -(this._bottomArcNode.getFullBoundsReference().getHeight() + d3));
        this._topArcNode.setOffset(-d4 / 2.0, -(this._topArcNode.getFullBoundsReference().getHeight() + this._bottomArcNode.getFullBoundsReference().getHeight() + d3));
        this.addChild(this._topArcNode);
        this.addChild(this._bottomArcNode);
        this.rotate(GlaciersConstants.YAW_ROTATION);
        this.update();
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
        this._ripple.removeIceRippleListener(this._rippleListener);
    }

    private void update() {
        Point2D point2D = this._glacier.getSurfaceAtELAReference();
        Color color = GlaciersConstants.RIPPLE_ABOVE_ELA_COLOR;
        if (point2D != null && this._ripple.getX() >= point2D.getX()) {
            color = GlaciersConstants.RIPPLE_BELOW_ELA_COLOR;
        }
        this._topArcNode.setStrokePaint(color);
        this._bottomArcNode.setStrokePaint(color);
        this._mvt.modelToView(this._ripple.getPositionReference(), this._pView);
        this.setOffset(this._pView.getX(), this._pView.getY());
    }
}

