/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class IceNode
extends PComposite {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final GlaciersModelViewTransform _mvt;
    private final GeneralPath _crossSectionPath;
    private final PPath _crossSectionNode;
    private final GeneralPath _surfacePath;
    private final GeneralPath _surfaceBelowELAPath;
    private final PPath _surfaceNode;
    private final PPath _surfaceBelowELANode;
    private final Point2D _pModel;
    private final Point2D _pView;

    public IceNode(Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                IceNode.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._mvt = glaciersModelViewTransform;
        this._crossSectionPath = new GeneralPath();
        this._crossSectionNode = new PPath(this._crossSectionPath);
        this._crossSectionNode.setPaint(GlaciersConstants.ICE_CROSS_SECTION_COLOR);
        this._crossSectionNode.setStroke(null);
        this.addChild(this._crossSectionNode);
        this._surfacePath = new GeneralPath();
        this._surfaceNode = new PPath(this._surfacePath);
        this._surfaceNode.setPaint(GlaciersConstants.ICE_SURFACE_ABOVE_ELA_COLOR);
        this._surfaceNode.setStroke(null);
        this.addChild(this._surfaceNode);
        this._surfaceBelowELAPath = new GeneralPath();
        this._surfaceBelowELANode = new PPath(this._surfacePath);
        this._surfaceBelowELANode.setPaint(GlaciersConstants.ICE_SURFACE_BELOW_ELA_COLOR);
        this._surfaceBelowELANode.setStroke(null);
        this.addChild(this._surfaceBelowELANode);
        this._pModel = new Point2D.Double();
        this._pView = new Point2D.Double();
        this.update();
    }

    public static double getDx() {
        return 80.0;
    }

    private void update() {
        this._crossSectionPath.reset();
        this._surfacePath.reset();
        this._surfaceBelowELAPath.reset();
        double d = this._glacier.getLength();
        if (d > 0.0) {
            double d2 = this._glacier.getHeadwallX();
            double d3 = this._glacier.getTerminusX();
            Point2D point2D = this._glacier.getSurfaceAtELAReference();
            double d4 = 0.0;
            boolean bl = false;
            for (double d5 = d2; d5 <= d3; d5 += 80.0) {
                double d6;
                d4 = this._glacier.getSurfaceElevation(d5);
                this._pModel.setLocation(d5, d4);
                this._mvt.modelToView(this._pModel, this._pView);
                if (d5 == d2) {
                    this._crossSectionPath.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                    this._surfacePath.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                } else {
                    this._crossSectionPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                    this._surfacePath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                }
                if (point2D != null && d5 >= point2D.getX()) {
                    if (!bl) {
                        this._pModel.setLocation(point2D);
                        this._mvt.modelToView(this._pModel, this._pView);
                        this._surfaceBelowELAPath.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                        bl = true;
                        if (d5 > point2D.getX()) {
                            this._pModel.setLocation(d5, d4);
                            this._mvt.modelToView(this._pModel, this._pView);
                            this._surfaceBelowELAPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                        }
                    } else {
                        this._surfaceBelowELAPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                    }
                }
                if (!(d > 80.0) || !((d6 = d3 - d5) > 0.0) || !(d6 < 80.0)) continue;
                d5 = d3 - 80.0;
            }
            boolean bl2 = false;
            for (double d7 = d3; d7 >= d2; d7 -= 80.0) {
                double d8;
                d4 = this._glacier.getValley().getElevation(d7);
                this._pModel.setLocation(d7, d4);
                this._mvt.modelToView(this._pModel, this._pView);
                this._crossSectionPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                double d9 = d7 + 500.0;
                d4 = this._glacier.getSurfaceElevation(d7) + 250.0;
                this._pModel.setLocation(d9, d4);
                this._mvt.modelToView(this._pModel, this._pView);
                this._surfacePath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                if (point2D != null && !bl2) {
                    d8 = point2D.getX() + 500.0;
                    if (d9 > d8) {
                        this._surfaceBelowELAPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                    } else {
                        this._pModel.setLocation(d8, point2D.getY() + 250.0);
                        this._mvt.modelToView(this._pModel, this._pView);
                        this._surfaceBelowELAPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                        bl2 = true;
                    }
                }
                if (!(d > 80.0) || !((d8 = d7 - d2) > 0.0) || !(d8 < 80.0)) continue;
                d7 = d2 + 80.0;
            }
            this._crossSectionPath.closePath();
            this._surfacePath.closePath();
            if (point2D != null && d3 >= point2D.getX()) {
                this._surfaceBelowELAPath.closePath();
            }
        }
        this._crossSectionNode.setPathTo(this._crossSectionPath);
        this._surfaceNode.setPathTo(this._surfacePath);
        this._surfaceBelowELANode.setPathTo(this._surfaceBelowELAPath);
    }
}

