/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IceFlowNode
extends PComposite {
    private static final Stroke VELOCITY_VECTOR_STROKE = new BasicStroke(1.0f);
    private static final Paint VELOCITY_VECTOR_STROKE_PAINT = null;
    private static final Paint VELOCITY_VECTOR_FILL_PAINT = Color.BLACK;
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final GlaciersModelViewTransform _mvt;
    private final PNode _parentNode;
    private boolean _isDirty;

    public IceFlowNode(Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                IceFlowNode.this.updateVectors();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._mvt = glaciersModelViewTransform;
        this._parentNode = new PComposite();
        this._parentNode.setOffset(0.0, 0.0);
        this.addChild(this._parentNode);
        this._isDirty = true;
        this.updateVectors();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this._isDirty) {
            this.updateVectors();
        }
    }

    private void updateVectors() {
        if (!this.getVisible()) {
            this._isDirty = true;
        } else {
            Vector2D vector2D = new Vector2D();
            Point2D.Double double_ = new Point2D.Double();
            this._parentNode.removeAllChildren();
            double d = this._glacier.getTerminusX();
            for (double d2 = this._glacier.getHeadwallX(); d2 <= d; d2 += 400.0) {
                double d3 = this._glacier.getValley().getElevation(d2);
                double d4 = d3 + this._glacier.getIceThickness(d2);
                for (double d5 = d3 + 20.0; d5 <= d4 - 0.0; d5 += 50.0) {
                    Vector2D vector2D2 = this._glacier.getIceVelocity(d2, d5, vector2D);
                    Point2D point2D = this._mvt.modelToView(vector2D2.getX(), vector2D2.getY(), double_);
                    VelocityVectorNode velocityVectorNode = new VelocityVectorNode(point2D.getX(), point2D.getY(), 5.0);
                    this._parentNode.addChild(velocityVectorNode);
                    ((PNode)velocityVectorNode).setOffset(this._mvt.modelToView(d2, d5, double_));
                }
            }
            this._isDirty = false;
        }
    }

    public static Icon createIcon() {
        PNode pNode = new PNode();
        VelocityVectorNode velocityVectorNode = new VelocityVectorNode(30.0, 0.0, 1.0);
        velocityVectorNode.setOffset(0.0, 0.0);
        pNode.addChild(velocityVectorNode);
        velocityVectorNode = new VelocityVectorNode(20.0, 0.0, 1.0);
        velocityVectorNode.setOffset(0.0, 4.0);
        pNode.addChild(velocityVectorNode);
        velocityVectorNode = new VelocityVectorNode(10.0, 0.0, 1.0);
        velocityVectorNode.setOffset(0.0, 8.0);
        pNode.addChild(velocityVectorNode);
        Image image = pNode.toImage();
        return new ImageIcon(image);
    }

    private static class VelocityVectorNode
    extends Vector2DNode {
        public VelocityVectorNode(double d, double d2, double d3) {
            super(d, d2, 1.0, d3);
            this.setHeadSize(4.0, 4.0);
            this.setTailWidth(1.0);
            this.setArrowFillPaint(VELOCITY_VECTOR_FILL_PAINT);
            this.setArrowStroke(VELOCITY_VECTOR_STROKE);
            this.setArrowStrokePaint(VELOCITY_VECTOR_STROKE_PAINT);
            this.setFractionalHeadHeight(0.5);
            this.setValueVisible(false);
        }
    }
}

