/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.control.ScrollArrowNode;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Borehole;
import edu.colorado.phet.glaciers.model.Debris;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.model.IBoreholeProducer;
import edu.colorado.phet.glaciers.model.IDebrisProducer;
import edu.colorado.phet.glaciers.model.IIceRippleProducer;
import edu.colorado.phet.glaciers.model.IToolProducer;
import edu.colorado.phet.glaciers.model.IceRipple;
import edu.colorado.phet.glaciers.model.Viewport;
import edu.colorado.phet.glaciers.view.BoreholeNode;
import edu.colorado.phet.glaciers.view.CoordinatesNode;
import edu.colorado.phet.glaciers.view.DebrisNode;
import edu.colorado.phet.glaciers.view.ELAValueNode;
import edu.colorado.phet.glaciers.view.EquilibriumLineNode;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.IceFlowNode;
import edu.colorado.phet.glaciers.view.IceNode;
import edu.colorado.phet.glaciers.view.IceRippleNode;
import edu.colorado.phet.glaciers.view.MountainsAndValleyNode;
import edu.colorado.phet.glaciers.view.PanControlNode;
import edu.colorado.phet.glaciers.view.SnowPatchNode;
import edu.colorado.phet.glaciers.view.SnowfallNode;
import edu.colorado.phet.glaciers.view.UnitsChangeListener;
import edu.colorado.phet.glaciers.view.ValleyFloorWorkaroundNode;
import edu.colorado.phet.glaciers.view.ViewportNode;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.ToolNodeFactory;
import edu.colorado.phet.glaciers.view.tools.ToolboxNode;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class GlaciersPlayArea
extends JPanel
implements IBoreholeProducer.IBoreholeProducerListener,
IDebrisProducer.IDebrisProducerListener,
IIceRippleProducer.IIceRippleProducerListener,
IToolProducer.IToolProducerListener,
UnitsChangeListener {
    private static final Color BACKGROUND_COLOR = GlaciersConstants.CONTROL_PANEL_BACKGROUND_COLOR;
    private static final Border CANVAS_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    private static final Border PLAY_AREA_BORDER = BorderFactory.createLineBorder(BACKGROUND_COLOR, 5);
    private final GlaciersModel _model;
    private final Viewport _birdsEyeViewport;
    private final Viewport _zoomedViewport;
    private final PhetPCanvas _birdsEyeCanvas;
    private final PhetPCanvas _zoomedCanvas;
    private final PLayer _backgroundLayer;
    private final PLayer _iceLayer;
    private final PLayer _ripplesLayer;
    private final PLayer _debrisLayer;
    private final PLayer _velocityLayer;
    private final PLayer _boreholeLayer;
    private final PLayer _snowPatchLayer;
    private final PLayer _snowfallLayer;
    private final PLayer _coordinatesLayer;
    private final PLayer _toolboxLayer;
    private final PLayer _toolsLayer;
    private final PLayer _viewportLayer;
    private final PLayer _debugLayer;
    private final IceFlowNode _iceFlowNode;
    private final SnowfallNode _snowfallNode;
    private final ToolboxNode _toolboxNode;
    private final PNode _panControlNode;
    private final EquilibriumLineNode _equilibriumLineNode;
    private final CoordinatesNode _coordinatesNode;
    private final ELAValueNode _elaValueNode;
    private final HashMap _toolsMap;
    private final GlaciersModelViewTransform _mvt;
    private final ScrollArrowNode _leftScrollArrowNode;
    private final ScrollArrowNode _rightScrollArrowNode;
    private final HashMap _boreholesMap;
    private final HashMap _debrisMap;
    private final HashMap _ripplesMap;
    private boolean _englishUnits = true;

    public GlaciersPlayArea(GlaciersModel glaciersModel) {
        this._model = glaciersModel;
        this._model.addToolProducerListener(this);
        this._model.addBoreholeProducerListener(this);
        this._model.addDebrisProducerListener(this);
        this._model.addIceRippleProducerListener(this);
        this._mvt = new GlaciersModelViewTransform(0.1, 0.2, 0.0, 0.0, false, true);
        this._toolsMap = new HashMap();
        this._boreholesMap = new HashMap();
        this._debrisMap = new HashMap();
        this._ripplesMap = new HashMap();
        Point2D point2D = this._model.getValley().getHeadwallPositionReference();
        this._birdsEyeViewport = new Viewport("birds-eye");
        this._birdsEyeViewport.setPosition(point2D.getX() + GlaciersConstants.BIRDS_EYE_VIEWPORT_OFFSET.getX(), point2D.getY() + GlaciersConstants.BIRDS_EYE_VIEWPORT_OFFSET.getY());
        this._birdsEyeViewport.addViewportListener(new Viewport.ViewportListener(){

            public void boundsChanged() {
                GlaciersPlayArea.this.handleBirdsEyeViewportChanged();
            }
        });
        this._zoomedViewport = new Viewport("zoomed");
        this._zoomedViewport.addViewportListener(new Viewport.ViewportListener(){

            public void boundsChanged() {
                GlaciersPlayArea.this.verticallyAlignZoomedViewport();
                GlaciersPlayArea.this.handleZoomedViewportChanged();
            }
        });
        this._birdsEyeCanvas = new PhetPCanvas();
        this._birdsEyeCanvas.setBorder(null);
        this._birdsEyeCanvas.setBackground(GlaciersConstants.BIRDS_EYE_CANVAS_COLOR);
        this._birdsEyeCanvas.getCamera().setViewScale(0.1);
        this._zoomedCanvas = new PhetPCanvas();
        this._zoomedCanvas.setBorder(null);
        this._zoomedCanvas.setBackground(GlaciersConstants.ZOOMED_CANVAS_COLOR);
        this._zoomedCanvas.getCamera().setViewScale(1.0);
        Object object = new JPanel(new BorderLayout());
        ((Container)object).add(Box.createVerticalStrut(75), "West");
        ((Container)object).add((Component)this._birdsEyeCanvas, "Center");
        ((JComponent)object).setBorder(CANVAS_BORDER);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(BACKGROUND_COLOR);
        jPanel.add((Component)object, "Center");
        jPanel.add(Box.createVerticalStrut(4), "South");
        Serializable serializable = new JPanel(new BorderLayout());
        serializable.add(this._zoomedCanvas, "Center");
        serializable.setBorder(CANVAS_BORDER);
        this.setBorder(PLAY_AREA_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)serializable, "Center");
        object = new PlayAreaResizeListener(this);
        this.addComponentListener((ComponentListener)object);
        this.addAncestorListener((AncestorListener)object);
        this._backgroundLayer = new PLayer();
        this._iceLayer = new PLayer();
        this._ripplesLayer = new PLayer();
        this._debrisLayer = new PLayer();
        this._boreholeLayer = new PLayer();
        this._snowPatchLayer = new PLayer();
        this._snowfallLayer = new PLayer();
        this._coordinatesLayer = new PLayer();
        this._velocityLayer = new PLayer();
        this._toolboxLayer = new PLayer();
        this._toolsLayer = new PLayer();
        this._viewportLayer = new PLayer();
        this._debugLayer = new PLayer();
        this.addToBothViews(this._backgroundLayer);
        this.addToBothViews(this._iceLayer);
        this.addToZoomedView(this._ripplesLayer);
        this.addToZoomedView(this._debrisLayer);
        this.addToBothViews(this._snowPatchLayer);
        this.addToZoomedView(this._boreholeLayer);
        this.addToBothViews(this._snowfallLayer);
        this.addToZoomedView(this._velocityLayer);
        this.addToZoomedView(this._coordinatesLayer);
        this.addToZoomedView(this._toolboxLayer);
        this.addToBothViews(this._toolsLayer);
        this.addToBirdsEyeView(this._viewportLayer);
        this.addToBothViews(this._debugLayer);
        float f = 10.0f;
        serializable = new ViewportNode(this._zoomedViewport, f, this._mvt);
        this._viewportLayer.addChild((PNode)serializable);
        MountainsAndValleyNode mountainsAndValleyNode = new MountainsAndValleyNode(this._model.getValley(), this._mvt);
        this._backgroundLayer.addChild(mountainsAndValleyNode);
        ValleyFloorWorkaroundNode valleyFloorWorkaroundNode = new ValleyFloorWorkaroundNode(this._model.getValley(), this._mvt);
        this._backgroundLayer.addChild(valleyFloorWorkaroundNode);
        IceNode iceNode = new IceNode(this._model.getGlacier(), this._mvt);
        this._iceLayer.addChild(iceNode);
        this._iceFlowNode = new IceFlowNode(this._model.getGlacier(), this._mvt);
        this._velocityLayer.addChild(this._iceFlowNode);
        SnowPatchNode snowPatchNode = new SnowPatchNode(this._model.getGlacier(), this._mvt);
        this._snowPatchLayer.addChild(snowPatchNode);
        this._snowfallNode = new SnowfallNode(this._model.getGlacier(), this._mvt);
        this._snowfallLayer.addChild(this._snowfallNode);
        this._coordinatesNode = new CoordinatesNode(this._model, this._mvt, this._englishUnits);
        this._coordinatesLayer.addChild(this._coordinatesNode);
        this._equilibriumLineNode = new EquilibriumLineNode(this._model.getGlacier(), this._mvt);
        this._iceLayer.addChild(this._equilibriumLineNode);
        this._toolboxNode = new ToolboxNode(this._model, this._mvt);
        this._toolboxLayer.addChild(this._toolboxNode);
        this._elaValueNode = new ELAValueNode(this._model.getClimate());
        this._elaValueNode.setVisible(false);
        this._toolboxLayer.addChild(this._elaValueNode);
        this._panControlNode = new PanControlNode(this._birdsEyeViewport, this._zoomedViewport, this._mvt, 84000.0);
        this._viewportLayer.addChild(this._panControlNode);
        this._leftScrollArrowNode = new ScrollArrowNode.LeftScrollArrowNode(this._birdsEyeViewport, this._zoomedViewport);
        this._toolboxLayer.addChild(this._leftScrollArrowNode);
        this._rightScrollArrowNode = new ScrollArrowNode.RightScrollArrowNode(this._birdsEyeViewport, this._zoomedViewport, 84000.0);
        this._toolboxLayer.addChild(this._rightScrollArrowNode);
    }

    public void resetZoomedViewport() {
        double d = Math.max(-3400.0, this._birdsEyeViewport.getX());
        this._zoomedViewport.setPosition(d, this._birdsEyeViewport.getY());
    }

    public void setZoomedViewportPosition(Point2D point2D) {
        this._zoomedViewport.setPosition(point2D);
    }

    public Point2D getZoomedViewportPosition() {
        return this._zoomedViewport.getPosition();
    }

    public void setEquilibriumLineVisible(boolean bl) {
        this._equilibriumLineNode.setVisible(bl);
    }

    public void setAxesVisible(boolean bl) {
        this._coordinatesNode.setVisible(bl);
    }

    public void setIceFlowVisible(boolean bl) {
        this._iceFlowNode.setVisible(bl);
    }

    public void setSnowfallVisible(boolean bl) {
        this._snowfallNode.setVisible(bl);
    }

    public static Point2D getBirdsEyeViewportOffset() {
        return new Point2D.Double(GlaciersConstants.BIRDS_EYE_VIEWPORT_OFFSET.getX(), GlaciersConstants.BIRDS_EYE_VIEWPORT_OFFSET.getY());
    }

    public PNode getToolboxNode() {
        return this._toolboxNode;
    }

    public PhetPCanvas getZoomedCanvas() {
        return this._zoomedCanvas;
    }

    private void addToBirdsEyeView(PLayer pLayer) {
        this._birdsEyeCanvas.getCamera().addLayer(pLayer);
        this._birdsEyeCanvas.getRoot().addChild(pLayer);
    }

    private void addToZoomedView(PLayer pLayer) {
        this._zoomedCanvas.getCamera().addLayer(pLayer);
        this._zoomedCanvas.getRoot().addChild(pLayer);
    }

    private void addToBothViews(PLayer pLayer) {
        this.addToBirdsEyeView(pLayer);
        this.addToZoomedView(pLayer);
    }

    private void updateLayout() {
        this.updateBirdsEyeViewportBounds();
        this.updateZoomedViewportBounds();
        this.updateSnowfallBounds();
        this.constrainZoomedViewport();
    }

    private void updateBirdsEyeViewportBounds() {
        Rectangle rectangle = this._birdsEyeCanvas.getBounds();
        assert (!((RectangularShape)rectangle).isEmpty());
        double d = this._birdsEyeCanvas.getCamera().getViewScale();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)rectangle).getWidth() / d, ((RectangularShape)rectangle).getHeight() / d);
        Rectangle2D rectangle2D = this._mvt.viewToModel(double_);
        this._birdsEyeViewport.setBounds(this._birdsEyeViewport.getX(), this._birdsEyeViewport.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private void updateZoomedViewportBounds() {
        Rectangle rectangle = this._zoomedCanvas.getBounds();
        double d = this._zoomedCanvas.getCamera().getViewScale();
        Rectangle2D rectangle2D = this._mvt.modelToView(this._zoomedViewport.getBoundsReference());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), ((RectangularShape)rectangle).getWidth() / d, ((RectangularShape)rectangle).getHeight() / d);
        Rectangle2D rectangle2D2 = this._mvt.viewToModel(rectangle2D);
        this._zoomedViewport.setBounds(rectangle2D2);
    }

    private void updateSnowfallBounds() {
        Rectangle2D rectangle2D = this._birdsEyeViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._zoomedViewport.getBoundsReference();
        double d = Math.max(rectangle2D.getY(), rectangle2D2.getY());
        double d2 = rectangle2D.getHeight() + (d - rectangle2D.getY());
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
        this._snowfallNode.setWorldBounds(double_);
    }

    private void verticallyAlignZoomedViewport() {
        Rectangle2D rectangle2D = this._zoomedViewport.getBounds();
        double d = rectangle2D.getCenterX();
        double d2 = this._model.getValley().getElevation(d);
        double d3 = d2 + 0.75 * rectangle2D.getHeight();
        rectangle2D.setRect(rectangle2D.getX(), d3, rectangle2D.getWidth(), rectangle2D.getHeight());
        this._zoomedViewport.setBounds(rectangle2D);
    }

    private void constrainZoomedViewport() {
        Rectangle2D rectangle2D = this._birdsEyeViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._zoomedViewport.getBoundsReference();
        if (rectangle2D2.getX() < rectangle2D.getX()) {
            double d = rectangle2D.getX() - rectangle2D2.getX();
            this._zoomedViewport.translate(d, 0.0);
        } else if (rectangle2D2.getMaxX() > rectangle2D.getMaxX()) {
            double d = rectangle2D2.getMaxX() - rectangle2D.getMaxX();
            this._zoomedViewport.translate(-d, 0.0);
        }
    }

    private void handleBirdsEyeViewportChanged() {
        Rectangle2D rectangle2D = this._birdsEyeViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        double d = this._birdsEyeCanvas.getCamera().getViewScale();
        this._birdsEyeCanvas.getCamera().setViewOffset(-rectangle2D2.getX() * d, -rectangle2D2.getY() * d);
    }

    private void handleZoomedViewportChanged() {
        Rectangle2D rectangle2D = this._zoomedViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        double d = this._zoomedCanvas.getCamera().getViewScale();
        this._zoomedCanvas.getCamera().setViewOffset(-rectangle2D2.getX() * d, -rectangle2D2.getY() * d);
        this.updateToolboxPosition();
        this.updateELAValuePosition();
        this.updateCoordinateAxes();
        this.updateScrollArrows();
    }

    private void updateScrollArrows() {
        Rectangle2D rectangle2D = this._zoomedViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        double d = rectangle2D2.getX() + 5.0;
        double d2 = rectangle2D2.getY() + this._leftScrollArrowNode.getFullBoundsReference().getHeight() / 2.0 + 5.0;
        this._leftScrollArrowNode.setOffset(d, d2);
        d = rectangle2D2.getMaxX() - 5.0;
        d2 = rectangle2D2.getY() + this._rightScrollArrowNode.getFullBoundsReference().getHeight() / 2.0 + 5.0;
        this._rightScrollArrowNode.setOffset(d, d2);
        this._leftScrollArrowNode.setVisible(this._zoomedViewport.getBoundsReference().getX() > this._birdsEyeViewport.getBoundsReference().getX());
        this._rightScrollArrowNode.setVisible(this._zoomedViewport.getBoundsReference().getMaxX() < 84000.0);
    }

    private void updateToolboxPosition() {
        Rectangle2D rectangle2D = this._zoomedViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        double d = rectangle2D2.getX() + 5.0;
        double d2 = rectangle2D2.getY() + rectangle2D2.getHeight() - this._toolboxNode.getFullBoundsReference().getHeight() - 5.0;
        this._toolboxNode.setOffset(d, d2);
    }

    private void updateELAValuePosition() {
        double d = this._toolboxNode.getFullBoundsReference().getMaxX() + 5.0;
        double d2 = this._toolboxNode.getFullBoundsReference().getMaxY() - this._elaValueNode.getFullBoundsReference().getHeight();
        this._elaValueNode.setOffset(d, d2);
    }

    private void updateCoordinateAxes() {
        this._coordinatesNode.update(this._zoomedViewport.getBoundsReference());
    }

    public void toolAdded(AbstractTool abstractTool) {
        AbstractToolNode abstractToolNode = ToolNodeFactory.createNode(abstractTool, this._model, this._mvt, this._toolboxNode.getTrashCanDelegate(), this._englishUnits);
        this._toolsLayer.addChild(abstractToolNode);
        this._toolsMap.put(abstractTool, abstractToolNode);
    }

    public void toolRemoved(AbstractTool abstractTool) {
        AbstractToolNode abstractToolNode = (AbstractToolNode)this._toolsMap.get(abstractTool);
        this._toolsLayer.removeChild(abstractToolNode);
        this._toolsMap.remove(abstractTool);
        abstractToolNode.cleanup();
    }

    public void boreholeAdded(Borehole borehole) {
        BoreholeNode boreholeNode = new BoreholeNode(borehole, this._mvt);
        this._boreholeLayer.addChild(boreholeNode);
        this._boreholesMap.put(borehole, boreholeNode);
    }

    public void boreholeRemoved(Borehole borehole) {
        BoreholeNode boreholeNode = (BoreholeNode)this._boreholesMap.get(borehole);
        this._boreholeLayer.removeChild(boreholeNode);
        this._boreholesMap.remove(borehole);
        boreholeNode.cleanup();
    }

    public void debrisAdded(Debris debris) {
        DebrisNode debrisNode = new DebrisNode(debris, this._model.getGlacier(), this._mvt);
        this._debrisLayer.addChild(debrisNode);
        this._debrisMap.put(debris, debrisNode);
    }

    public void debrisRemoved(Debris debris) {
        DebrisNode debrisNode = (DebrisNode)this._debrisMap.get(debris);
        assert (debrisNode != null);
        this._debrisLayer.removeChild(debrisNode);
        this._debrisMap.remove(debris);
        debrisNode.cleanup();
    }

    public void rippleAdded(IceRipple iceRipple) {
        IceRippleNode iceRippleNode = new IceRippleNode(iceRipple, this._model.getGlacier(), this._mvt);
        this._ripplesLayer.addChild(iceRippleNode);
        this._ripplesMap.put(iceRipple, iceRippleNode);
    }

    public void rippleRemoved(IceRipple iceRipple) {
        IceRippleNode iceRippleNode = (IceRippleNode)this._ripplesMap.get(iceRipple);
        assert (iceRippleNode != null);
        this._ripplesLayer.removeChild(iceRippleNode);
        this._ripplesMap.remove(iceRipple);
        iceRippleNode.cleanup();
    }

    public void unitsChanged(boolean bl) {
        this._englishUnits = bl;
        this._coordinatesNode.setEnglishUnits(bl);
        Set set = this._toolsMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AbstractToolNode abstractToolNode = (AbstractToolNode)this._toolsMap.get(iterator.next());
            abstractToolNode.setEnglishUnits(bl);
        }
    }

    private static class PlayAreaResizeListener
    extends ComponentAdapter
    implements AncestorListener {
        private GlaciersPlayArea _playArea;
        private boolean _layoutDirty;

        public PlayAreaResizeListener(GlaciersPlayArea glaciersPlayArea) {
            this._playArea = glaciersPlayArea;
            this._layoutDirty = true;
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this._playArea.isShowing()) {
                this._playArea.updateLayout();
                this._layoutDirty = false;
            } else {
                this._layoutDirty = true;
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (this._layoutDirty && this._playArea.isShowing()) {
                this._playArea.updateLayout();
                this._layoutDirty = false;
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

