/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.GlaciersPlayArea;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EquilibriumLineNode
extends PhetPNode {
    private static final Color STROKE_COLOR = Color.RED;
    private static final Stroke STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final GlaciersModelViewTransform _mvt;
    private final Point2D _pModel;
    private final Point2D _pView;
    private final PPath _pathNode;
    private final GeneralPath _path;

    public EquilibriumLineNode(Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                EquilibriumLineNode.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._mvt = glaciersModelViewTransform;
        this._pModel = new Point2D.Double();
        this._pView = new Point2D.Double();
        this._path = new GeneralPath();
        this._pathNode = new PPath();
        this._pathNode.setStroke(STROKE);
        this._pathNode.setStrokePaint(STROKE_COLOR);
        this.addChild(this._pathNode);
        this.update();
    }

    private void update() {
        this._path.reset();
        double d = this._glacier.getClimate().getELA();
        this._pModel.setLocation(GlaciersPlayArea.getBirdsEyeViewportOffset().getX(), d);
        this._mvt.modelToView(this._pModel, this._pView);
        this._path.moveTo((float)this._pView.getX(), (float)this._pView.getY());
        if (d > this._glacier.getHeadwallY()) {
            this._pModel.setLocation(this._glacier.getHeadwallX(), d);
            this._mvt.modelToView(this._pModel, this._pView);
            this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
        } else {
            Point2D point2D = this._glacier.getSurfaceAtELAReference();
            if (point2D != null) {
                this._pModel.setLocation(point2D.getX(), d);
                this._mvt.modelToView(this._pModel, this._pView);
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                this._pModel.setLocation(point2D.getX() + 500.0, d + 250.0);
                this._mvt.modelToView(this._pModel, this._pView);
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
            } else {
                double d2 = this._glacier.getValley().getX(d);
                this._pModel.setLocation(d2, d);
                this._mvt.modelToView(this._pModel, this._pView);
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                this._pModel.setLocation(d2 + 500.0, d + 250.0);
                this._mvt.modelToView(this._pModel, this._pView);
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
            }
        }
        this._pathNode.setPathTo(this._path);
    }

    public static Icon createIcon() {
        PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, 30.0, 0.0));
        pPath.setStroke(STROKE);
        pPath.setStrokePaint(STROKE_COLOR);
        Image image = pPath.toImage();
        return new ImageIcon(image);
    }
}

