/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.Debris;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class DebrisNode
extends PComposite {
    private final Debris _debris;
    private final Glacier _glacier;
    private BoulderNode _boulderNode;
    private final Debris.DebrisListener _debrisListener;
    private final GlaciersModelViewTransform _mvt;
    private final Point2D _pModel;
    private final Point2D _pView;

    public DebrisNode(Debris debris, Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._debris = debris;
        this._glacier = glacier;
        this._mvt = glaciersModelViewTransform;
        this._debrisListener = new Debris.DebrisAdapter(){

            public void positionChanged() {
                DebrisNode.this.update();
            }

            public void onValleyFloorChanged(Debris debris) {
                DebrisNode.this.update();
            }

            public void deleteMe(Debris debris) {
                DebrisNode.this.update();
            }
        };
        this._debris.addDebrisListener(this._debrisListener);
        this._boulderNode = new BoulderNode(1.0);
        this.addChild(this._boulderNode);
        this.setVisible(this._debris.getZ() == 0.0);
        this._pModel = new Point2D.Double();
        this._pView = new Point2D.Double();
        this.update();
    }

    public void cleanup() {
        this._debris.removeDebrisListener(this._debrisListener);
    }

    private void update() {
        double d = this._glacier.getSurfaceElevation(this._debris.getX());
        if (this._debris.getY() >= d) {
            double d2 = this._debris.getX() + 500.0 * this._debris.getZ() / 250.0;
            this._pModel.setLocation(d2, this._debris.getY() + this._debris.getZ());
            this.setVisible(true);
        } else {
            this._pModel.setLocation(this._debris.getX(), this._debris.getY());
            this.setVisible(this._debris.getZ() == 0.0);
        }
        this._mvt.modelToView(this._pModel, this._pView);
        this.setOffset(this._pView);
    }

    private static class BoulderNode
    extends PPath {
        public BoulderNode(double d) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d, 2.0 * d, 2.0 * d);
            this.setPathTo(double_);
            this.setStroke(null);
            this.setPaint(GlaciersConstants.DEBRIS_COLOR);
        }
    }
}

