/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.view.DistanceAxisNode;
import edu.colorado.phet.glaciers.view.ElevationAxisNode;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CoordinatesNode
extends PhetPNode {
    private static final Color AXIS_COLOR = Color.BLACK;
    private final GlaciersModelViewTransform _mvt;
    private final ElevationAxisNode _leftElevationAxisNode;
    private final ElevationAxisNode _rightElevationAxisNode;
    private final DistanceAxisNode _distanceAxisNode;

    public CoordinatesNode(GlaciersModel glaciersModel, GlaciersModelViewTransform glaciersModelViewTransform, boolean bl) {
        this._mvt = glaciersModelViewTransform;
        this._leftElevationAxisNode = new ElevationAxisNode(glaciersModelViewTransform, GlaciersConstants.ELEVATION_AXIS_RANGE, false, bl);
        this.addChild(this._leftElevationAxisNode);
        this._rightElevationAxisNode = new ElevationAxisNode(glaciersModelViewTransform, GlaciersConstants.ELEVATION_AXIS_RANGE, true, bl);
        this.addChild(this._rightElevationAxisNode);
        this._distanceAxisNode = new DistanceAxisNode(glaciersModel.getValley(), glaciersModelViewTransform, bl);
        this.addChild(this._distanceAxisNode);
    }

    public void setEnglishUnits(boolean bl) {
        this._leftElevationAxisNode.setEnglishUnits(bl);
        this._rightElevationAxisNode.setEnglishUnits(bl);
        this._distanceAxisNode.setEnglishUnits(bl);
    }

    public void update(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        int n = (int)Math.max(0.0, rectangle2D.getX());
        int n2 = (int)Math.max(1.0, rectangle2D.getX() + rectangle2D.getWidth());
        this._distanceAxisNode.setRange(n, n2);
        this._leftElevationAxisNode.setOffset(rectangle2D2.getMinX() + 15.0, this._rightElevationAxisNode.getYOffset());
        this._rightElevationAxisNode.setOffset(rectangle2D2.getMaxX() - 15.0, this._rightElevationAxisNode.getYOffset());
    }

    public static Icon createIcon() {
        PNode pNode = new PNode();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        PPath pPath = new PPath(new Line2D.Double(-10.0, 0.0, 20.0, 0.0));
        pPath.setStroke(basicStroke);
        pPath.setStrokePaint(AXIS_COLOR);
        pNode.addChild(pPath);
        for (double d = -5.0; d < 20.0; d += 5.0) {
            PPath pPath2 = new PPath(new Line2D.Double(d, -1.0, d, 1.0));
            pPath2.setStroke(basicStroke);
            pPath2.setStrokePaint(AXIS_COLOR);
            pNode.addChild(pPath2);
        }
        PPath pPath3 = new PPath(new Line2D.Double(0.0, -10.0, 0.0, 10.0));
        pPath3.setStroke(basicStroke);
        pPath3.setStrokePaint(AXIS_COLOR);
        pNode.addChild(pPath3);
        for (double d = -5.0; d < 10.0; d += 5.0) {
            PPath pPath4 = new PPath(new Line2D.Double(-1.0, d, 1.0, d));
            pPath4.setStroke(basicStroke);
            pPath4.setStrokePaint(AXIS_COLOR);
            pNode.addChild(pPath4);
        }
        Image image = pNode.toImage();
        return new ImageIcon(image);
    }
}

