/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.module.intro;

import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.glaciers.GlaciersApplication;
import edu.colorado.phet.glaciers.GlaciersHelpBalloon;
import edu.colorado.phet.glaciers.GlaciersResources;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.ClimateControlPanel;
import edu.colorado.phet.glaciers.control.MiscControlPanel;
import edu.colorado.phet.glaciers.control.ViewControlPanel;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.module.GlaciersModule;
import edu.colorado.phet.glaciers.module.intro.IntroControlPanel;
import edu.colorado.phet.glaciers.persistence.IntroConfig;
import edu.colorado.phet.glaciers.view.GlaciersPlayArea;
import java.awt.Frame;

public class IntroModule
extends GlaciersModule {
    private final GlaciersPlayArea _playArea;
    private final IntroControlPanel _controlPanel;

    public IntroModule(Frame frame) {
        super(GlaciersStrings.TITLE_INTRO);
        GlaciersModel glaciersModel = this.getGlaciersModel();
        this._playArea = new GlaciersPlayArea(glaciersModel);
        this.setSimulationPanel(this._playArea);
        int n = GlaciersResources.getInt("controlPanel.minHeight", 100);
        this._controlPanel = new IntroControlPanel(glaciersModel, this._playArea, frame, this, true, n);
        this.setClockControlPanel(this._controlPanel);
        if (this.hasHelp()) {
            HelpPane helpPane = this.getDefaultHelpPane();
            GlaciersHelpBalloon glaciersHelpBalloon = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_STEADY_STATE_BUTTON, HelpBalloon.BOTTOM_LEFT, 200.0);
            helpPane.add(glaciersHelpBalloon);
            glaciersHelpBalloon.pointAt(this._controlPanel.getMiscControlPanel().getSteadyStateButton());
            GlaciersHelpBalloon glaciersHelpBalloon2 = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_SIM_SPEED, HelpBalloon.BOTTOM_LEFT, 190.0);
            helpPane.add(glaciersHelpBalloon2);
            glaciersHelpBalloon2.pointAt(this._controlPanel.getClockControlPanel().getFrameRateControl());
            GlaciersHelpBalloon glaciersHelpBalloon3 = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_TOOLBOX, HelpBalloon.BOTTOM_CENTER, 30.0);
            helpPane.add(glaciersHelpBalloon3);
            glaciersHelpBalloon3.pointAt(this._playArea.getToolboxNode(), this._playArea.getZoomedCanvas());
        }
        this.reset();
    }

    public void activate() {
        super.activate();
        this._controlPanel.activate();
    }

    public void deactivate() {
        this._controlPanel.deactivate();
        super.deactivate();
    }

    public boolean hasHelp() {
        return false;
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this._controlPanel.setHelpEnabled(bl);
        GlaciersApplication.getInstance().getPhetFrame().getHelpMenu().setHelpSelected(bl);
    }

    public void reset() {
        super.reset();
        GlaciersModel glaciersModel = this.getGlaciersModel();
        glaciersModel.reset();
        this.setClockRunningWhenActive(true);
        Glacier glacier = glaciersModel.getGlacier();
        Climate climate = glaciersModel.getClimate();
        ViewControlPanel viewControlPanel = this._controlPanel.getViewControlPanel();
        viewControlPanel.setEnglishUnitsSelected(true);
        viewControlPanel.setEquilibriumLineSelected(false);
        viewControlPanel.setIceFlowSelected(false);
        viewControlPanel.setSnowfallSelected(true);
        viewControlPanel.setCoordinatesSelected(false);
        ClimateControlPanel climateControlPanel = this._controlPanel.getClimateControlPanel();
        climateControlPanel.setSnowfall(climate.getSnowfall());
        climateControlPanel.setTemperature(climate.getTemperature());
        MiscControlPanel miscControlPanel = this._controlPanel.getMiscControlPanel();
        miscControlPanel.setSteadyStateButtonEnabled(!glacier.isSteadyState());
        this._playArea.resetZoomedViewport();
        this._playArea.setEquilibriumLineVisible(viewControlPanel.isEquilibriumLineSelected());
        this._playArea.setIceFlowVisible(viewControlPanel.isIceFlowSelected());
        this._playArea.setAxesVisible(viewControlPanel.isCoordinatesSelected());
    }

    public IntroConfig save() {
        IntroConfig introConfig = new IntroConfig();
        introConfig.setActive(this.isActive());
        GlaciersModel glaciersModel = this.getGlaciersModel();
        GlaciersClock glaciersClock = glaciersModel.getClock();
        introConfig.setClockFrameRate(glaciersClock.getFrameRate());
        introConfig.setClockRunning(this.getClockRunningWhenActive());
        introConfig.setSnowfall(glaciersModel.getClimate().getSnowfall());
        introConfig.setTemperature(glaciersModel.getClimate().getTemperature());
        introConfig.setZoomedViewportPosition(this._playArea.getZoomedViewportPosition());
        introConfig.setSnowfallSelected(this._controlPanel.getViewControlPanel().isSnowfallSelected());
        introConfig.setEquilibriumLineSelected(this._controlPanel.getViewControlPanel().isEquilibriumLineSelected());
        return introConfig;
    }

    public void load(IntroConfig introConfig) {
        if (introConfig.isActive()) {
            GlaciersApplication.getInstance().setActiveModule(this);
        }
        GlaciersModel glaciersModel = this.getGlaciersModel();
        GlaciersClock glaciersClock = glaciersModel.getClock();
        glaciersClock.setFrameRate(introConfig.getClockFrameRate());
        this.setClockRunningWhenActive(introConfig.isClockRunning());
        glaciersModel.getClimate().setSnowfall(introConfig.getSnowfall());
        glaciersModel.getClimate().setTemperature(introConfig.getTemperature());
        glaciersModel.getGlacier().setSteadyState();
        this._playArea.setZoomedViewportPosition(introConfig.getZoomedViewportPosition());
        this._controlPanel.getViewControlPanel().setSnowfallSelected(introConfig.isSnowfallSelected());
        this._controlPanel.getViewControlPanel().setEquilibriumLineSelected(introConfig.isEquilibriumLineSelected());
    }
}

