/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.module.intro;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.control.ClimateControlPanel;
import edu.colorado.phet.glaciers.control.GlaciersClockControlPanel;
import edu.colorado.phet.glaciers.control.GraphsControlPanel;
import edu.colorado.phet.glaciers.control.MiscControlPanel;
import edu.colorado.phet.glaciers.control.ViewControlPanel;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.view.GlaciersPlayArea;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;

public class IntroControlPanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = GlaciersConstants.CONTROL_PANEL_BACKGROUND_COLOR;
    private final ViewControlPanel _viewControlPanel;
    private final ClimateControlPanel _climateControlPanel;
    private final GlaciersClockControlPanel _clockControlPanel;
    private final MiscControlPanel _miscControlPanel;

    public IntroControlPanel(GlaciersModel glaciersModel, GlaciersPlayArea glaciersPlayArea, Frame frame, Module module, boolean bl, int n) {
        this._viewControlPanel = new ViewControlPanel(glaciersPlayArea);
        this._viewControlPanel.setCoordinatesCheckBoxVisible(false);
        this._viewControlPanel.setIceFlowCheckBoxVisible(false);
        this._climateControlPanel = new ClimateControlPanel(glaciersModel.getClimate(), bl);
        this._clockControlPanel = new GlaciersClockControlPanel(glaciersModel.getClock());
        this._miscControlPanel = new MiscControlPanel(glaciersModel.getGlacier(), frame, module);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n2 = 0;
        int n3 = 0;
        easyGridBagLayout.addFilledComponent(this._viewControlPanel, n2, n3++, 3);
        easyGridBagLayout.addFilledComponent(this._climateControlPanel, n2, n3++, 3);
        JPanel jPanel2 = new JPanel();
        EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout(jPanel2);
        jPanel2.setLayout(easyGridBagLayout2);
        n2 = 0;
        n3 = 0;
        easyGridBagLayout2.addAnchoredComponent(this._clockControlPanel, n2, n3++, 17);
        easyGridBagLayout2.addComponent(Box.createHorizontalStrut(10), n2, n3++);
        easyGridBagLayout2.addFilledComponent(new JSeparator(1), n2, n3++, 3);
        easyGridBagLayout2.addComponent(Box.createHorizontalStrut(10), n2, n3++);
        easyGridBagLayout2.addAnchoredComponent(this._miscControlPanel, n2, n3++, 13);
        JPanel jPanel3 = new JPanel();
        EasyGridBagLayout easyGridBagLayout3 = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout(easyGridBagLayout3);
        n2 = 0;
        n3 = 0;
        easyGridBagLayout3.addFilledComponent(Box.createVerticalStrut(n), n2, n3++, 1, 2, 3);
        easyGridBagLayout3.addAnchoredComponent(jPanel, n2++, n3, 10);
        easyGridBagLayout3.addAnchoredComponent(jPanel2, n2++, n3, 10);
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(jPanel3);
        Class[] classArray = new Class[]{ViewControlPanel.class, ClimateControlPanel.class, GraphsControlPanel.class, JTextComponent.class};
        SwingUtils.setBackgroundDeep(this, BACKGROUND_COLOR, classArray, false);
        this._viewControlPanel.addUnitsChangedListener(glaciersPlayArea);
        this._viewControlPanel.addUnitsChangedListener(this._climateControlPanel);
    }

    public ViewControlPanel getViewControlPanel() {
        return this._viewControlPanel;
    }

    public ClimateControlPanel getClimateControlPanel() {
        return this._climateControlPanel;
    }

    public MiscControlPanel getMiscControlPanel() {
        return this._miscControlPanel;
    }

    public GlaciersClockControlPanel getClockControlPanel() {
        return this._clockControlPanel;
    }

    public void setHelpEnabled(boolean bl) {
        this._miscControlPanel.setHelpEnabled(bl);
    }

    public void activate() {
        this._miscControlPanel.activate();
    }

    public void deactivate() {
        this._miscControlPanel.deactivate();
    }
}

