/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.glaciers.dialog.EvolutionStateDialog;
import edu.colorado.phet.glaciers.dialog.ModelConstantsDialog;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import java.awt.Frame;

public abstract class GlaciersModule
extends PiccoloModule {
    private final GlaciersModel _model = new GlaciersModel((GlaciersClock)this.getClock());
    private EvolutionStateDialog _evolutionStateDialog;
    private boolean _evolutionStateDialogVisible;
    private ModelConstantsDialog _modelConstantsDialog;
    private boolean _modelConstantsDialogVisible;

    public GlaciersModule(String string) {
        super(string, new GlaciersClock());
        this.setMonitorPanel(null);
        this.setSimulationPanel(null);
        this.setClockControlPanel(null);
        this.setLogoPanel(null);
        this.setControlPanel(null);
        this.setHelpPanel(null);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this._evolutionStateDialog = new EvolutionStateDialog((Frame)PhetApplication.getInstance().getPhetFrame(), this._model.getGlacier(), this.getName());
            this._evolutionStateDialogVisible = false;
            this._modelConstantsDialog = new ModelConstantsDialog((Frame)PhetApplication.getInstance().getPhetFrame(), this._model.getGlacier(), this.getName());
            this._modelConstantsDialogVisible = false;
        }
    }

    protected GlaciersModel getGlaciersModel() {
        return this._model;
    }

    public void setEvolutionStateDialogVisible(boolean bl) {
        this._evolutionStateDialogVisible = bl;
        if (this.isActive() && this._evolutionStateDialog != null) {
            this._evolutionStateDialog.setVisible(bl);
        }
    }

    public void setModelConstantsDialogVisible(boolean bl) {
        this._modelConstantsDialogVisible = bl;
        if (this.isActive() && this._modelConstantsDialog != null) {
            this._modelConstantsDialog.setVisible(bl);
        }
    }

    public void activate() {
        super.activate();
        if (this._evolutionStateDialog != null && this._evolutionStateDialogVisible) {
            this._evolutionStateDialog.setVisible(true);
        }
        if (this._modelConstantsDialog != null && this._modelConstantsDialogVisible) {
            this._modelConstantsDialog.setVisible(true);
        }
    }

    public void deactivate() {
        if (this._evolutionStateDialog != null) {
            this._evolutionStateDialog.setVisible(false);
        }
        if (this._modelConstantsDialog != null) {
            this._modelConstantsDialog.setVisible(false);
        }
        super.deactivate();
    }
}

