/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.Random;

public class TracerFlag
extends AbstractTool {
    private static final double MIN_FALLOVER_ANGLE = Math.toRadians(30.0);
    private static final double MAX_FALLOVER_ANGLE = Math.toRadians(80.0);
    private static final Random RANDOM_FALLOVER = new Random();
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private boolean _onValleyFloor;

    public TracerFlag(Point2D point2D, Glacier glacier) {
        super(point2D);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                TracerFlag.this.checkForDeletion();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._onValleyFloor = false;
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    public void startDrag() {
        this._onValleyFloor = false;
    }

    protected void constrainDrop() {
        double d;
        double d2 = this.getX();
        double d3 = this._glacier.getSurfaceElevation(d2);
        boolean bl = this._onValleyFloor = d3 == (d = this._glacier.getValley().getElevation(d2));
        if (this.getY() > d3) {
            this.setPosition(d2, d3);
        } else if (this.getY() <= d) {
            if (this._onValleyFloor) {
                this.setPosition(d2, d);
            } else {
                this.setPosition(d2, d + 1.0);
            }
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (!this.isDragging() && !this._onValleyFloor) {
            double d;
            double d2;
            double d3;
            double d4 = this.getElevation();
            if (d4 > (d3 = this._glacier.getSurfaceElevation(this.getX()))) {
                d4 = d3;
            }
            Vector2D vector2D = this._glacier.getIceVelocity(this.getX(), d4);
            double d5 = clockEvent.getSimulationTimeChange();
            double d6 = this.getX() + vector2D.getX() * d5;
            double d7 = this.getY() + vector2D.getY() * d5;
            double d8 = this._glacier.getTerminusX() + 1.0;
            if (d6 > d8) {
                d6 = d8;
            }
            if (d7 > (d2 = this._glacier.getSurfaceElevation(d6))) {
                d7 = d2;
            }
            if (d2 == (d = this._glacier.getValley().getElevation(d6))) {
                this._onValleyFloor = true;
                this.setOrientation(TracerFlag.calculateRandomFalloverAngle());
            }
            this.setPosition(d6, d7);
        }
    }

    private static double calculateRandomFalloverAngle() {
        return MIN_FALLOVER_ANGLE + RANDOM_FALLOVER.nextDouble() * (MAX_FALLOVER_ANGLE - MIN_FALLOVER_ANGLE);
    }

    private void checkForDeletion() {
        double d;
        if (this._onValleyFloor && !this.isDeletedSelf() && (d = this._glacier.getIceThickness(this.getX())) > 0.0) {
            this.deleteSelf();
        }
    }
}

