/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Thermometer
extends AbstractTool {
    private final Glacier _glacier;
    private final Climate.ClimateListener _climateListener;
    private double _temperature;
    private final ArrayList _listeners;

    public Thermometer(Point2D point2D, Glacier glacier) {
        super(point2D);
        this._glacier = glacier;
        this._climateListener = new Climate.ClimateAdapter(){

            public void temperatureChanged() {
                Thermometer.this.updateTemperature();
            }
        };
        this._glacier.getClimate().addClimateListener(this._climateListener);
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        super.cleanup();
        this._glacier.getClimate().removeClimateListener(this._climateListener);
    }

    private void setTemperature(double d) {
        if (d != this._temperature) {
            this._temperature = d;
            this.notifyTemperatureChanged();
        }
    }

    public double getTemperature() {
        return this._temperature;
    }

    protected void constrainDrop() {
        double d = this.getX();
        double d2 = this._glacier.getSurfaceElevation(d);
        if (this.getX() < d || this.getY() <= d2) {
            this.setPosition(d, d2 + 100.0);
        }
    }

    protected void handlePositionChanged() {
        this.updateTemperature();
    }

    private void updateTemperature() {
        double d = this.getElevation();
        double d2 = this._glacier.getClimate().getTemperature(d);
        this.setTemperature(d2);
    }

    public void addThermometerListener(ThermometerListener thermometerListener) {
        this._listeners.add(thermometerListener);
    }

    public void removeThermometerListener(ThermometerListener thermometerListener) {
        this._listeners.remove(thermometerListener);
    }

    private void notifyTemperatureChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ThermometerListener)iterator.next()).temperatureChanged();
        }
    }

    public static interface ThermometerListener {
        public void temperatureChanged();
    }
}

