/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Movable {
    private static final Point2D DEFAULT_POSITION = new Point2D.Double(0.0, 0.0);
    private Point2D _position;
    private double _orientation;
    private final ArrayList _listeners;

    public Movable(Point2D point2D) {
        this(point2D, 0.0);
    }

    public Movable(Point2D point2D, double d) {
        this._position = new Point2D.Double(point2D.getX(), point2D.getY());
        this._orientation = d;
        this._listeners = new ArrayList();
    }

    public void cleanup() {
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        if (d != this._position.getX() || d2 != this._position.getY()) {
            this._position.setLocation(d, d2);
            this.notifyPositionChanged();
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this._position.getX(), this._position.getY());
    }

    public Point2D getPositionReference() {
        return this._position;
    }

    public double getX() {
        return this._position.getX();
    }

    public double getY() {
        return this._position.getY();
    }

    public void setOrientation(double d) {
        if (d != this._orientation) {
            this._orientation = d;
            this.notifyOrientationChanged();
        }
    }

    public double getOrientation() {
        return this._orientation;
    }

    public void addMovableListener(MovableListener movableListener) {
        this._listeners.add(movableListener);
    }

    public void removeMovableListener(MovableListener movableListener) {
        this._listeners.remove(movableListener);
    }

    private void notifyPositionChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((MovableListener)iterator.next()).positionChanged();
        }
    }

    private void notifyOrientationChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((MovableListener)iterator.next()).orientationChanged();
        }
    }

    public static class MovableAdapter
    implements MovableListener {
        public void positionChanged() {
        }

        public void orientationChanged() {
        }
    }

    public static interface MovableListener {
        public void positionChanged();

        public void orientationChanged();
    }
}

