/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class IceThicknessTool
extends AbstractTool {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private double _thickness;
    private final ArrayList _listeners;

    public IceThicknessTool(Point2D point2D, Glacier glacier) {
        super(point2D);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                IceThicknessTool.this.updateThickness();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    public double getThickness() {
        return this._thickness;
    }

    private void setThickness(double d) {
        if (d != this._thickness) {
            this._thickness = d;
            this.notifyThicknessChanged();
        }
    }

    protected void constrainDrop() {
        if (this._thickness > 0.0) {
            double d = this.getX();
            double d2 = this._glacier.getValley().getElevation(d);
            this.setPosition(d, d2);
        }
    }

    protected void handlePositionChanged() {
        this.updateThickness();
    }

    private void updateThickness() {
        double d = this.getX();
        double d2 = this._glacier.getIceThickness(d);
        this.setThickness(d2);
    }

    public void addIceThicknessToolListener(IceThicknessToolListener iceThicknessToolListener) {
        this._listeners.add(iceThicknessToolListener);
    }

    public void removeIceThicknessToolListener(IceThicknessToolListener iceThicknessToolListener) {
        this._listeners.remove(iceThicknessToolListener);
    }

    private void notifyThicknessChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((IceThicknessToolListener)iterator.next()).thicknessChanged();
        }
    }

    public static interface IceThicknessToolListener {
        public void thicknessChanged();
    }
}

