/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class IceRipple
extends ClockAdapter {
    private Point2D _position;
    private final Dimension _size;
    private final double _zOffset;
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private boolean _deletedSelf;
    private ArrayList _listeners;

    public IceRipple(double d, Dimension dimension, double d2, Glacier glacier) {
        this._position = new Point2D.Double(d, glacier.getSurfaceElevation(d));
        this._size = new Dimension(dimension);
        this._zOffset = d2;
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                IceRipple.this.checkForDeletion();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._deletedSelf = false;
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
    }

    private void deleteSelf() {
        if (!this._deletedSelf) {
            this._deletedSelf = true;
            this.notifyDeleteMe();
        }
    }

    private void setPosition(double d, double d2) {
        if (d != this._position.getX() || d2 != this._position.getY()) {
            this._position.setLocation(d, d2);
            this.notifyPositionChanged();
        }
    }

    public Point2D getPositionReference() {
        return this._position;
    }

    public double getX() {
        return this._position.getX();
    }

    public Dimension getSize() {
        return new Dimension(this._size);
    }

    public double getZOffset() {
        return this._zOffset;
    }

    private void checkForDeletion() {
        double d;
        if (!this._deletedSelf && (d = this._glacier.getIceThickness(this.getX())) == 0.0) {
            this.deleteSelf();
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (!this._deletedSelf) {
            double d = this._glacier.getSurfaceElevation(this.getX());
            Vector2D vector2D = this._glacier.getIceVelocity(this.getX(), d);
            double d2 = clockEvent.getSimulationTimeChange();
            double d3 = this.getX() + vector2D.getX() * d2;
            double d4 = this._glacier.getSurfaceElevation(d3);
            if (d3 >= this._glacier.getTerminusX()) {
                this.deleteSelf();
            } else {
                this.setPosition(d3, d4);
            }
        }
    }

    public void addIceRippleListener(IceRippleListener iceRippleListener) {
        this._listeners.add(iceRippleListener);
    }

    public void removeIceRippleListener(IceRippleListener iceRippleListener) {
        this._listeners.remove(iceRippleListener);
    }

    private void notifyPositionChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((IceRippleListener)iterator.next()).positionChanged();
        }
    }

    private void notifyDeleteMe() {
        ArrayList arrayList = new ArrayList(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((IceRippleListener)iterator.next()).deleteMe(this);
        }
    }

    public static class IceRippleAdapter
    implements IceRippleListener {
        public void positionChanged() {
        }

        public void deleteMe(IceRipple iceRipple) {
        }
    }

    public static interface IceRippleListener {
        public void positionChanged();

        public void deleteMe(IceRipple var1);
    }
}

