/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Borehole;
import edu.colorado.phet.glaciers.model.BoreholeDrill;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Debris;
import edu.colorado.phet.glaciers.model.DebrisGenerator;
import edu.colorado.phet.glaciers.model.EndMoraine;
import edu.colorado.phet.glaciers.model.GPSReceiver;
import edu.colorado.phet.glaciers.model.GlacialBudgetMeter;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import edu.colorado.phet.glaciers.model.IBoreholeProducer;
import edu.colorado.phet.glaciers.model.IDebrisProducer;
import edu.colorado.phet.glaciers.model.IIceRippleProducer;
import edu.colorado.phet.glaciers.model.IToolProducer;
import edu.colorado.phet.glaciers.model.IceRipple;
import edu.colorado.phet.glaciers.model.IceThicknessTool;
import edu.colorado.phet.glaciers.model.Thermometer;
import edu.colorado.phet.glaciers.model.TracerFlag;
import edu.colorado.phet.glaciers.model.Valley;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class GlaciersModel
implements IBoreholeProducer,
IDebrisProducer,
IIceRippleProducer,
IToolProducer {
    private static final DoubleRange YEARS_PER_RIPPLE_GENERATED_RANGE = new DoubleRange(20.0, 100.0);
    private static final DoubleRange RIPPLE_LENGTH_RANGE = new DoubleRange(50.0, 187.5);
    private static final DoubleRange RIPPLE_ZOFFSET_FACTOR_RANGE = new DoubleRange(0.3, 0.8);
    private final GlaciersClock _clock;
    private final Glacier _glacier;
    private final ArrayList _tools;
    private final ArrayList _toolProducerListeners;
    private final AbstractTool.ToolListener _toolSelfDeletionListener;
    private final BoreholeDrill.BoreholeDrillListener _boreholeDrillListener;
    private final Borehole.BoreholeListener _boreholeSelfDeletionListener;
    private final ArrayList _boreholes;
    private final ArrayList _boreholeProducerListeners;
    private final EndMoraine _endMoraine;
    private final ArrayList _debris;
    private final ArrayList _debrisProducerListeners;
    private final Debris.DebrisListener _debrisSelfDeletionListener;
    private final DebrisGenerator _debrisGenerator;
    private final Point3D _pDebris;
    private double _timeSinceLastDebrisGenerated;
    private final ArrayList _ripples;
    private final ArrayList _rippleProducerListeners;
    private final IceRipple.IceRippleListener _rippleSelfDeletionListener;
    private double _timeSinceLastRippleGenerated;
    private final Random _randomRippleTime;
    private final Random _randomRippleHeight;
    private final Random _randomRippleZOffset;

    public GlaciersModel(GlaciersClock glaciersClock) {
        this._clock = glaciersClock;
        Valley valley = new Valley();
        Climate climate = new Climate(GlaciersConstants.TEMPERATURE_RANGE.getDefault(), GlaciersConstants.SNOWFALL_RANGE.getDefault());
        this._glacier = new Glacier(valley, climate);
        this._clock.addClockListener(this._glacier);
        this._tools = new ArrayList();
        this._toolProducerListeners = new ArrayList();
        this._boreholes = new ArrayList();
        this._boreholeProducerListeners = new ArrayList();
        this._endMoraine = new EndMoraine(this._glacier);
        this._debris = new ArrayList();
        this._debrisProducerListeners = new ArrayList();
        this._debrisGenerator = new DebrisGenerator(this._glacier);
        this._pDebris = new Point3D.Double();
        this._timeSinceLastDebrisGenerated = 1.0;
        this._ripples = new ArrayList();
        this._rippleProducerListeners = new ArrayList();
        this._timeSinceLastRippleGenerated = YEARS_PER_RIPPLE_GENERATED_RANGE.getMax();
        this._randomRippleTime = new Random();
        this._randomRippleHeight = new Random();
        this._randomRippleZOffset = new Random();
        this._boreholeDrillListener = new BoreholeDrill.BoreholeDrillListener(){

            public void drillAt(Point2D point2D) {
                GlaciersModel.this.addBorehole(point2D);
            }
        };
        this._boreholeSelfDeletionListener = new Borehole.BoreholeAdapter(){

            public void deleteMe(Borehole borehole) {
                GlaciersModel.this.removeBorehole(borehole);
            }
        };
        this._toolSelfDeletionListener = new AbstractTool.ToolAdapter(){

            public void deleteMe(AbstractTool abstractTool) {
                GlaciersModel.this.removeTool(abstractTool);
            }
        };
        this._debrisSelfDeletionListener = new Debris.DebrisAdapter(){

            public void deleteMe(Debris debris) {
                GlaciersModel.this.removeDebris(debris);
            }

            public void onValleyFloorChanged(Debris debris) {
                if (debris.isOnValleyFloor()) {
                    GlaciersModel.this._endMoraine.addDebris(debris);
                }
            }
        };
        this._rippleSelfDeletionListener = new IceRipple.IceRippleAdapter(){

            public void deleteMe(IceRipple iceRipple) {
                GlaciersModel.this.removeIceRipple(iceRipple);
            }
        };
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                GlaciersModel.this.generateDebris(clockEvent);
                GlaciersModel.this.generateIceRipple(clockEvent);
            }
        });
    }

    public GlaciersClock getClock() {
        return this._clock;
    }

    public Glacier getGlacier() {
        return this._glacier;
    }

    public Valley getValley() {
        return this._glacier.getValley();
    }

    public Climate getClimate() {
        return this._glacier.getClimate();
    }

    public void reset() {
        this._clock.setFrameRate(GlaciersConstants.CLOCK_FRAME_RATE_RANGE.getDefault());
        this._clock.resetSimulationTime();
        this.getClimate().setTemperature(GlaciersConstants.TEMPERATURE_RANGE.getDefault());
        this.getClimate().setSnowfall(GlaciersConstants.SNOWFALL_RANGE.getDefault());
        this._glacier.setSteadyState();
        this.removeAllTools();
        this.removeAllBoreholes();
        this.removeAllDebris();
    }

    public BoreholeDrill addBoreholeDrill(Point2D point2D) {
        BoreholeDrill boreholeDrill = new BoreholeDrill(point2D, this.getGlacier());
        boreholeDrill.addBoreholeDrillListener(this._boreholeDrillListener);
        this.addTool(boreholeDrill);
        return boreholeDrill;
    }

    public GlacialBudgetMeter addGlacialBudgetMeter(Point2D point2D) {
        GlacialBudgetMeter glacialBudgetMeter = new GlacialBudgetMeter(point2D, this.getGlacier());
        this.addTool(glacialBudgetMeter);
        return glacialBudgetMeter;
    }

    public GPSReceiver createGPSReceiver(Point2D point2D) {
        GPSReceiver gPSReceiver = new GPSReceiver(point2D);
        this.addTool(gPSReceiver);
        return gPSReceiver;
    }

    public IceThicknessTool addIceThicknessTool(Point2D point2D) {
        IceThicknessTool iceThicknessTool = new IceThicknessTool(point2D, this.getGlacier());
        this.addTool(iceThicknessTool);
        return iceThicknessTool;
    }

    public Thermometer addThermometer(Point2D point2D) {
        Thermometer thermometer = new Thermometer(point2D, this.getGlacier());
        this.addTool(thermometer);
        return thermometer;
    }

    public TracerFlag addTracerFlag(Point2D point2D) {
        TracerFlag tracerFlag = new TracerFlag(point2D, this.getGlacier());
        this.addTool(tracerFlag);
        return tracerFlag;
    }

    public void addToolProducerListener(IToolProducer.IToolProducerListener iToolProducerListener) {
        this._toolProducerListeners.add(iToolProducerListener);
    }

    private void addTool(AbstractTool abstractTool) {
        if (this._tools.contains(abstractTool)) {
            throw new IllegalStateException("attempted to add tool twice: " + abstractTool.getClass().getName());
        }
        abstractTool.addToolListener(this._toolSelfDeletionListener);
        this._tools.add(abstractTool);
        this._clock.addClockListener(abstractTool);
        this.notifyToolAdded(abstractTool);
    }

    public void removeTool(AbstractTool abstractTool) {
        if (!this._tools.contains(abstractTool)) {
            throw new IllegalStateException("attempted to remove a tool that doesn't exist: " + abstractTool.getClass().getName());
        }
        if (abstractTool instanceof BoreholeDrill) {
            ((BoreholeDrill)abstractTool).removeBoreholeDrillListener(this._boreholeDrillListener);
        }
        abstractTool.removeToolListener(this._toolSelfDeletionListener);
        this._tools.remove(abstractTool);
        this._clock.removeClockListener(abstractTool);
        this.notifyToolRemoved(abstractTool);
        abstractTool.cleanup();
    }

    public void removeAllTools() {
        ArrayList arrayList = new ArrayList(this._tools);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.removeTool((AbstractTool)iterator.next());
        }
    }

    private void notifyToolAdded(AbstractTool abstractTool) {
        Iterator iterator = this._toolProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IToolProducer.IToolProducerListener)iterator.next()).toolAdded(abstractTool);
        }
    }

    private void notifyToolRemoved(AbstractTool abstractTool) {
        Iterator iterator = this._toolProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IToolProducer.IToolProducerListener)iterator.next()).toolRemoved(abstractTool);
        }
    }

    public Borehole addBorehole(Point2D point2D) {
        Borehole borehole = new Borehole(this._glacier, point2D);
        borehole.addBoreholeListener(this._boreholeSelfDeletionListener);
        this._boreholes.add(borehole);
        this._clock.addClockListener(borehole);
        this.notifyBoreholeAdded(borehole);
        return borehole;
    }

    public void removeBorehole(Borehole borehole) {
        if (!this._boreholes.contains(borehole)) {
            throw new IllegalStateException("attempted to remove a borehole that doesn't exist");
        }
        borehole.removeBoreholeListener(this._boreholeSelfDeletionListener);
        this._boreholes.remove(borehole);
        this._clock.removeClockListener(borehole);
        this.notifyBoreholeRemoved(borehole);
        borehole.cleanup();
    }

    public void removeAllBoreholes() {
        ArrayList arrayList = new ArrayList(this._boreholes);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.removeBorehole((Borehole)iterator.next());
        }
    }

    public void addBoreholeProducerListener(IBoreholeProducer.IBoreholeProducerListener iBoreholeProducerListener) {
        this._boreholeProducerListeners.add(iBoreholeProducerListener);
    }

    private void notifyBoreholeAdded(Borehole borehole) {
        Iterator iterator = this._boreholeProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IBoreholeProducer.IBoreholeProducerListener)iterator.next()).boreholeAdded(borehole);
        }
    }

    private void notifyBoreholeRemoved(Borehole borehole) {
        Iterator iterator = this._boreholeProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IBoreholeProducer.IBoreholeProducerListener)iterator.next()).boreholeRemoved(borehole);
        }
    }

    public Debris addDebris(Point3D point3D) {
        Debris debris = new Debris(point3D, this._glacier);
        debris.addDebrisListener(this._debrisSelfDeletionListener);
        this._debris.add(debris);
        this._clock.addClockListener(debris);
        this.notifyDebrisAdded(debris);
        return debris;
    }

    public void removeDebris(Debris debris) {
        if (!this._debris.contains(debris)) {
            throw new IllegalStateException("attempted to remove debris that doesn't exist");
        }
        debris.removeDebrisListener(this._debrisSelfDeletionListener);
        this._debris.remove(debris);
        this._clock.removeClockListener(debris);
        this.notifyDebrisRemoved(debris);
        debris.cleanup();
    }

    public void removeAllDebris() {
        ArrayList arrayList = new ArrayList(this._debris);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.removeDebris((Debris)iterator.next());
        }
        this._endMoraine.removeAllDebris();
    }

    public void addDebrisProducerListener(IDebrisProducer.IDebrisProducerListener iDebrisProducerListener) {
        this._debrisProducerListeners.add(iDebrisProducerListener);
    }

    private void notifyDebrisAdded(Debris debris) {
        Iterator iterator = this._debrisProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IDebrisProducer.IDebrisProducerListener)iterator.next()).debrisAdded(debris);
        }
    }

    private void notifyDebrisRemoved(Debris debris) {
        Iterator iterator = this._debrisProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IDebrisProducer.IDebrisProducerListener)iterator.next()).debrisRemoved(debris);
        }
    }

    private void generateDebris(ClockEvent clockEvent) {
        if (this._glacier.getLength() > 0.0) {
            Point3D point3D;
            this._timeSinceLastDebrisGenerated += clockEvent.getSimulationTimeChange();
            if (this._timeSinceLastDebrisGenerated >= 1.0 && (point3D = this._debrisGenerator.generateDebrisPosition(this._pDebris)) != null) {
                this._timeSinceLastDebrisGenerated = 0.0;
                this.addDebris(this._pDebris);
            }
        }
    }

    public IceRipple addIceRipple(double d, Dimension dimension, double d2) {
        IceRipple iceRipple = new IceRipple(d, dimension, d2, this._glacier);
        iceRipple.addIceRippleListener(this._rippleSelfDeletionListener);
        this._ripples.add(iceRipple);
        this._clock.addClockListener(iceRipple);
        this.notifyIceRippleAdded(iceRipple);
        return iceRipple;
    }

    public void removeIceRipple(IceRipple iceRipple) {
        if (!this._ripples.contains(iceRipple)) {
            throw new IllegalStateException("attempted to remove ripple that doesn't exist");
        }
        iceRipple.removeIceRippleListener(this._rippleSelfDeletionListener);
        this._ripples.remove(iceRipple);
        this._clock.removeClockListener(iceRipple);
        this.notifyIceRippleRemoved(iceRipple);
        iceRipple.cleanup();
    }

    public void addIceRippleProducerListener(IIceRippleProducer.IIceRippleProducerListener iIceRippleProducerListener) {
        this._rippleProducerListeners.add(iIceRippleProducerListener);
    }

    private void notifyIceRippleAdded(IceRipple iceRipple) {
        Iterator iterator = this._rippleProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IIceRippleProducer.IIceRippleProducerListener)iterator.next()).rippleAdded(iceRipple);
        }
    }

    private void notifyIceRippleRemoved(IceRipple iceRipple) {
        Iterator iterator = this._rippleProducerListeners.iterator();
        while (iterator.hasNext()) {
            ((IIceRippleProducer.IIceRippleProducerListener)iterator.next()).rippleRemoved(iceRipple);
        }
    }

    private void generateIceRipple(ClockEvent clockEvent) {
        if (this._glacier.getLength() > 0.0) {
            this._timeSinceLastRippleGenerated += clockEvent.getSimulationTimeChange();
            double d = YEARS_PER_RIPPLE_GENERATED_RANGE.getMin() + this._randomRippleTime.nextDouble() * YEARS_PER_RIPPLE_GENERATED_RANGE.getLength();
            if (this._timeSinceLastRippleGenerated >= d) {
                double d2 = this._glacier.getHeadwallX() + 1.0;
                double d3 = RIPPLE_LENGTH_RANGE.getMin() + this._randomRippleHeight.nextDouble() * RIPPLE_LENGTH_RANGE.getLength();
                Dimension dimension = new Dimension(25, (int)d3);
                double d4 = RIPPLE_ZOFFSET_FACTOR_RANGE.getMin() + this._randomRippleZOffset.nextDouble() * RIPPLE_ZOFFSET_FACTOR_RANGE.getLength();
                double d5 = d4 * (250.0 - d3 - 10.0);
                this.addIceRipple(d2, dimension, d5);
                this._timeSinceLastRippleGenerated = 0.0;
            }
        }
    }
}

