/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.model.Debris;
import edu.colorado.phet.glaciers.model.Glacier;
import java.util.ArrayList;
import java.util.Iterator;

public class EndMoraine {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final ArrayList _debrisList;

    public EndMoraine(Glacier glacier) {
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void steadyStateChanged() {
                if (!EndMoraine.this._glacier.isSteadyState()) {
                    EndMoraine.this.removeAllDebris();
                }
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._debrisList = new ArrayList();
    }

    public void addDebris(Debris debris) {
        if (this._glacier.isSteadyState()) {
            if (!debris.isOnValleyFloor()) {
                System.out.println("WARNING - EndMoraine.addDebris: ignoring attempt to add debris that is not on the valley floor");
            } else if (!(debris.getX() > this._glacier.getTerminusX() + 10.0)) {
                if (EndMoraine.overlaps(debris, this._debrisList)) {
                    EndMoraine.pruneDebris(debris);
                } else {
                    this._debrisList.add(debris);
                }
            }
        }
    }

    public void removeAllDebris() {
        this._debrisList.clear();
    }

    private static void pruneDebris(Debris debris) {
        debris.deleteSelf();
    }

    private static boolean overlaps(Debris debris, ArrayList arrayList) {
        boolean bl = false;
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            Debris debris2 = null;
            while (iterator.hasNext() && !bl) {
                debris2 = (Debris)iterator.next();
                if (!(Math.abs(debris2.getZ() - debris.getZ()) <= 1.0)) continue;
                bl = true;
            }
        }
        return bl;
    }
}

