/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.glaciers.model.Glacier;
import java.util.Random;

public class DebrisGenerator {
    private final Glacier _glacier;
    private final Random _randomDebrisX;
    private final Random _randomDebrisY;
    private final Random _randomDebrisZ;
    private int _count;

    public DebrisGenerator(Glacier glacier) {
        this._glacier = glacier;
        this._randomDebrisX = new Random();
        this._randomDebrisY = new Random();
        this._randomDebrisZ = new Random();
        this._count = 0;
    }

    public Point3D generateDebrisPosition(Point3D point3D) {
        Point3D point3D2 = null;
        if (this._glacier.getLength() > 300.0) {
            double d = this._glacier.getHeadwallX() + 10.0;
            double d2 = this._glacier.getTerminusX() - 1.0;
            assert (d2 > d);
            double d3 = d + this._randomDebrisX.nextDouble() * (d2 - d);
            assert (d3 > d && d3 < d2);
            double d4 = this._glacier.getValley().getElevation(d3);
            double d5 = this._glacier.getSurfaceElevation(d3);
            if (d5 - d4 > 30.0) {
                double d6 = d4 + 10.0;
                double d7 = d5 - 1.0;
                assert (d7 > d6);
                double d8 = d6 + this._randomDebrisY.nextDouble() * (d7 - d6);
                assert (d8 > d6 && d8 < d7);
                double d9 = 0.0;
                if (this._count % 5 != 0) {
                    d9 = this._randomDebrisZ.nextDouble() * 250.0;
                    assert (d9 >= 0.0 && d9 <= 250.0);
                }
                point3D2 = point3D;
                point3D2.setLocation(d3, d8, d9);
                ++this._count;
            }
        }
        return point3D2;
    }
}

