/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import java.util.ArrayList;
import java.util.Iterator;

public class Climate {
    private double _temperature;
    private double _snowfall;
    private double _ela;
    private final ArrayList _listeners;

    public Climate(double d, double d2) {
        this._temperature = d;
        this._snowfall = d2;
        this._listeners = new ArrayList();
        this.updateELA();
    }

    public void setTemperature(double d) {
        if (d != this._temperature) {
            this._temperature = d;
            this.updateELA();
            this.notifyTemperatureChanged();
        }
    }

    public double getTemperature() {
        return this._temperature;
    }

    public void setSnowfall(double d) {
        assert (d >= 0.0);
        assert (d <= 2.0);
        if (d != this._snowfall) {
            this._snowfall = d;
            this.updateELA();
            this.notifySnowfallChanged();
        }
    }

    public double getSnowfall() {
        return this._snowfall;
    }

    public double getTemperature(double d) {
        assert (d >= 0.0);
        return this._temperature - 0.0065 * d;
    }

    public double getAblation(double d) {
        assert (d >= 0.0);
        double d2 = 0.0;
        double d3 = this._temperature - 21.0;
        double d4 = d3 * 80.0 + 4300.0;
        if (d <= d4) {
            d2 = 30.0 * (1.0 - Math.sin((d - 1100.0 - d3 * 80.0) / 2037.1832715762603));
        }
        double d5 = 5.5E-5 * Math.pow(d3 + 9.0, 5.0) + 0.01 * (d3 - 9.0) + 0.3;
        assert ((d2 += d5) >= 0.0);
        return d2;
    }

    public double getAccumulation(double d) {
        assert (d >= 0.0);
        double d2 = this._snowfall / 1.5;
        double d3 = 4600.0 - 2800.0 * d2;
        double d4 = 2.0 * d2;
        double d5 = 0.5 + 0.3183098861837907 * Math.atan((d - d3) / 300.0);
        double d6 = d4 * d5;
        assert (d6 >= 0.0);
        assert (d6 <= 2.0);
        return d6;
    }

    public double getGlacialBudget(double d) {
        assert (d >= 0.0);
        return this.getAccumulation(d) - this.getAblation(d);
    }

    public double getELA() {
        return this._ela;
    }

    private void updateELA() {
        double d = 4000.0;
        double d2 = -1000.0;
        double d3 = this.getGlacialBudget(d);
        double d4 = 0.0;
        while (Math.abs(d3) > 1.0E-5 && Math.abs(d2) >= 1.0) {
            if ((d += d2) < 0.0) {
                d = 0.0;
            } else if (d > 8000.0) {
                d = 8000.0;
                break;
            }
            d4 = this.getGlacialBudget(d);
            if (d2 > 0.0 && d4 > 0.0 && d4 > d3 || d2 < 0.0 && d4 < 0.0 && d4 < d3) {
                d2 = -(d2 / 2.0);
            }
            d3 = d4;
        }
        this._ela = d;
    }

    public void addClimateListener(ClimateListener climateListener) {
        this._listeners.add(climateListener);
    }

    public void removeClimateListener(ClimateListener climateListener) {
        this._listeners.remove(climateListener);
    }

    private void notifyTemperatureChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ClimateListener)iterator.next()).temperatureChanged();
        }
    }

    private void notifySnowfallChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ClimateListener)iterator.next()).snowfallChanged();
        }
    }

    public static class ClimateAdapter
    implements ClimateListener {
        public void temperatureChanged() {
        }

        public void snowfallChanged() {
        }
    }

    public static interface ClimateListener {
        public void temperatureChanged();

        public void snowfallChanged();
    }
}

