/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class BoreholeDrill
extends AbstractTool {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final ArrayList _listeners;

    public BoreholeDrill(Point2D point2D, Glacier glacier) {
        super(point2D);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                if (!BoreholeDrill.this.isDragging()) {
                    BoreholeDrill.this.constrainDrop();
                }
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    public void drill() {
        if (this._glacier.getIceThickness(this.getX()) > 0.0) {
            this.notifyDrillAt(this.getPosition());
        }
    }

    protected void constrainDrop() {
        double d = this.getX();
        double d2 = this._glacier.getSurfaceElevation(d);
        this.setPosition(d, d2);
    }

    public void addBoreholeDrillListener(BoreholeDrillListener boreholeDrillListener) {
        this._listeners.add(boreholeDrillListener);
    }

    public void removeBoreholeDrillListener(BoreholeDrillListener boreholeDrillListener) {
        this._listeners.remove(boreholeDrillListener);
    }

    private void notifyDrillAt(Point2D point2D) {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((BoreholeDrillListener)iterator.next()).drillAt(point2D);
        }
    }

    public static interface BoreholeDrillListener {
        public void drillAt(Point2D var1);
    }
}

