/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.glaciers.model.Movable;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractTool
extends Movable
implements ClockListener {
    private boolean _dragging = false;
    private boolean _deletedSelf;
    private final ArrayList _listeners = new ArrayList();

    public AbstractTool(Point2D point2D) {
        super(point2D);
        this.addMovableListener(new Movable.MovableAdapter(){

            public void positionChanged() {
                AbstractTool.this.handlePositionChanged();
            }
        });
    }

    protected void deleteSelf() {
        if (!this._deletedSelf) {
            this._deletedSelf = true;
            this.notifyDeleteMe();
        }
    }

    public double getElevation() {
        return this.getY();
    }

    public void setDragging(boolean bl) {
        if (bl != this._dragging) {
            this._dragging = bl;
            this.notifyDraggingChanged();
            if (!bl) {
                this.constrainDrop();
            }
        }
    }

    protected void constrainDrop() {
    }

    public boolean isDragging() {
        return this._dragging;
    }

    protected boolean isDeletedSelf() {
        return this._deletedSelf;
    }

    public void addToolListener(ToolListener toolListener) {
        this._listeners.add(toolListener);
    }

    public void removeToolListener(ToolListener toolListener) {
        this._listeners.remove(toolListener);
    }

    private void notifyDraggingChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ToolListener)iterator.next()).draggingChanged();
        }
    }

    private void notifyDeleteMe() {
        ArrayList arrayList = new ArrayList(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ToolListener)iterator.next()).deleteMe(this);
        }
    }

    protected void handlePositionChanged() {
    }

    public void clockPaused(ClockEvent clockEvent) {
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockTicked(ClockEvent clockEvent) {
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }

    public static class ToolAdapter
    implements ToolListener {
        public void draggingChanged() {
        }

        public void deleteMe(AbstractTool abstractTool) {
        }
    }

    public static interface ToolListener {
        public void draggingChanged();

        public void deleteMe(AbstractTool var1);
    }
}

