/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.view.controls.DoubleSpinner;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelConstantsPanel
extends JPanel {
    private final double _defaultAccelerationM;
    private final double _defaultAccelerationB;

    public ModelConstantsPanel(final Glacier glacier) {
        this._defaultAccelerationM = glacier.debug_getAccelerationM();
        final DoubleSpinner doubleSpinner = new DoubleSpinner(this._defaultAccelerationM, 0.01, 0.05, 1.0E-5, "0.00000", new Dimension(100, 22));
        doubleSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                glacier.debug_setAccelerationM(doubleSpinner.getDoubleValue());
            }
        });
        JLabel jLabel = new JLabel("( 0.01, 0.05 )");
        this._defaultAccelerationB = glacier.debug_getAccelerationB();
        final DoubleSpinner doubleSpinner2 = new DoubleSpinner(this._defaultAccelerationB, -136.0, -100.0, 0.01, "0.00", new Dimension(100, 22));
        doubleSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                glacier.debug_setAccelerationB(doubleSpinner2.getDoubleValue());
            }
        });
        JLabel jLabel2 = new JLabel("( -136, -100 )");
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                doubleSpinner.setValue(ModelConstantsPanel.this._defaultAccelerationM);
                glacier.debug_setAccelerationM(ModelConstantsPanel.this._defaultAccelerationM);
                doubleSpinner2.setValue(ModelConstantsPanel.this._defaultAccelerationB);
                glacier.debug_setAccelerationB(ModelConstantsPanel.this._defaultAccelerationB);
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(new Insets(2, 3, 2, 3));
        easyGridBagLayout.setAnchor(17);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("See model.txt for details."), n, n2++, 3, 1);
        n2 = 0;
        easyGridBagLayout.addComponent(Box.createVerticalStrut(10), ++n, n2++, 3, 1);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("<html><u>name</u></html>"), ++n, n2++);
        easyGridBagLayout.addComponent(new JLabel("<html><u>value</u></html>"), n, n2++);
        easyGridBagLayout.addComponent(new JLabel("<html><u>range (min, max)</u></html>"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addAnchoredComponent(new JLabel("acc_m:"), ++n, n2++, 13);
        easyGridBagLayout.addComponent(doubleSpinner, n, n2++);
        easyGridBagLayout.addComponent(jLabel, n, n2++);
        n2 = 0;
        easyGridBagLayout.addAnchoredComponent(new JLabel("acc_b:"), ++n, n2++, 13);
        easyGridBagLayout.addComponent(doubleSpinner2, n, n2++);
        easyGridBagLayout.addComponent(jLabel2, n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(Box.createVerticalStrut(10), ++n, n2++, 3, 1);
        n2 = 0;
        easyGridBagLayout.addAnchoredComponent(jButton, ++n, n2++, 3, 1, 10);
    }

    public void cleanup() {
    }
}

