/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class HelpButton
extends JButton {
    public static final String SHOW_HELP = PhetCommonResources.getInstance().getLocalizedString("Common.HelpPanel.ShowHelp");
    public static final String HIDE_HELP = PhetCommonResources.getInstance().getLocalizedString("Common.HelpPanel.HideHelp");
    private final Module _module;

    public HelpButton(Module module) {
        this._module = module;
        this.setEnabled(module.hasHelp());
        this.setText(HIDE_HELP);
        double d = this.getPreferredSize().getWidth();
        this.setText(SHOW_HELP);
        double d2 = this.getPreferredSize().getWidth();
        this.setPreferredSize(new Dimension((int)Math.max(d, d2), (int)this.getPreferredSize().getHeight()));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpButton.this.setHelpEnabled(!HelpButton.this.isHelpEnabled());
            }
        });
    }

    public void setHelpEnabled(boolean bl) {
        if (bl != this.isHelpEnabled()) {
            this.setText(bl ? HIDE_HELP : SHOW_HELP);
            this._module.setHelpEnabled(bl);
        }
    }

    public boolean isHelpEnabled() {
        return this.getText().equals(HIDE_HELP);
    }
}

