/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EvolutionStatePanel
extends JPanel {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final Glacier.EvolutionState _currentState;
    private final Glacier.EvolutionState _previousState;
    private final NumberDisplay _elaCurrent;
    private final NumberDisplay _elaPrevious;
    private final NumberDisplay _timescaleCurrent;
    private final NumberDisplay _timescalePrevious;
    private final NumberDisplay _deltaQelaCurrent;
    private final NumberDisplay _deltaQelaPrevious;
    private final NumberDisplay _qelaCurrent;
    private final NumberDisplay _qelaPrevious;
    private final NumberDisplay _qelaxCurrent;
    private final NumberDisplay _qelaxPrevious;
    private final NumberDisplay _glacierLengthCurrent;
    private final NumberDisplay _glacierLengthPrevious;
    private final NumberDisplay _deltaLengthCurrent;
    private final NumberDisplay _deltaLengthPrevious;
    private final Point2DDisplay _terminusCurrent;
    private final Point2DDisplay _terminusPrevious;

    public EvolutionStatePanel(Glacier glacier) {
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierListener(){

            public void iceThicknessChanged() {
                EvolutionStatePanel.this.update();
            }

            public void steadyStateChanged() {
                EvolutionStatePanel.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._currentState = new Glacier.EvolutionState();
        this._previousState = new Glacier.EvolutionState();
        this._elaCurrent = new NumberDisplay("0.00");
        this._elaPrevious = new NumberDisplay("0.00");
        this._timescaleCurrent = new NumberDisplay("0.00");
        this._timescalePrevious = new NumberDisplay("0.00");
        this._deltaQelaCurrent = new NumberDisplay("0.0000");
        this._deltaQelaPrevious = new NumberDisplay("0.0000");
        this._qelaCurrent = new NumberDisplay("0.00");
        this._qelaPrevious = new NumberDisplay("0.00");
        this._qelaxCurrent = new NumberDisplay("0.00");
        this._qelaxPrevious = new NumberDisplay("0.00");
        this._glacierLengthCurrent = new NumberDisplay("0.00");
        this._glacierLengthPrevious = new NumberDisplay("0.00");
        this._deltaLengthCurrent = new NumberDisplay("0.00");
        this._deltaLengthPrevious = new NumberDisplay("0.00");
        this._terminusCurrent = new Point2DDisplay("0");
        this._terminusPrevious = new Point2DDisplay("0");
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setAnchor(13);
        easyGridBagLayout.setInsets(new Insets(3, 10, 3, 10));
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("<html><u>variable</u></html>"), n, n2++);
        easyGridBagLayout.addComponent(new JLabel("<html><u>current</u></html>"), n, n2++);
        easyGridBagLayout.addComponent(new JLabel("<html><u>previous</u></html>"), n, n2++);
        easyGridBagLayout.addComponent(new JLabel("<html><u>units</u></html>"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("ela:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._elaCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._elaPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("timescale:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._timescaleCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._timescalePrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("yrs"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("deltaQela:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._deltaQelaCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._deltaQelaPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("qela:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._qelaCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._qelaPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("qelax:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._qelaxCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._qelaxPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("glacier length:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._glacierLengthCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._glacierLengthPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("delta length:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._deltaLengthCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._deltaLengthPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(new JLabel("terminus:"), ++n, n2++);
        easyGridBagLayout.addComponent(this._terminusCurrent, n, n2++);
        easyGridBagLayout.addComponent(this._terminusPrevious, n, n2++);
        easyGridBagLayout.addComponent(new JLabel("m"), n, n2++);
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
    }

    private void update() {
        this._previousState.setState(this._currentState);
        this._currentState.setState(this._glacier.debug_getEvolutionState());
        this._elaCurrent.setValue(this._currentState.ela);
        this._elaPrevious.setValue(this._previousState.ela);
        this._timescaleCurrent.setValue(this._currentState.timescale);
        this._timescalePrevious.setValue(this._previousState.timescale);
        this._deltaQelaCurrent.setValue(this._currentState.deltaQela);
        this._deltaQelaPrevious.setValue(this._previousState.deltaQela);
        this._qelaCurrent.setValue(this._currentState.qela);
        this._qelaPrevious.setValue(this._previousState.qela);
        this._qelaxCurrent.setValue(this._currentState.qelax);
        this._qelaxPrevious.setValue(this._previousState.qelax);
        this._glacierLengthCurrent.setValue(this._currentState.glacierLength);
        this._glacierLengthPrevious.setValue(this._previousState.glacierLength);
        this._deltaLengthCurrent.setValue(this._currentState.deltaLength);
        this._deltaLengthPrevious.setValue(this._previousState.deltaLength);
        this._terminusCurrent.setValue(this._currentState.terminus);
        this._terminusPrevious.setValue(this._previousState.terminus);
    }

    private static class NumberDisplay
    extends JLabel {
        private final DecimalFormat format;

        public NumberDisplay(String string) {
            this.format = new DecimalFormat(string);
        }

        public void setValue(double d) {
            this.setText(this.format.format(d));
        }
    }

    private static class Point2DDisplay
    extends JLabel {
        private final DecimalFormat format;

        public Point2DDisplay(String string) {
            this.format = new DecimalFormat(string);
        }

        public void setValue(Point2D point2D) {
            this.setText("(" + this.format.format(point2D.getX()) + "," + this.format.format(point2D.getY()) + ")");
        }
    }
}

