/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.charts;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TemperatureVersusElevationChart
extends PaintImmediateDialog {
    private static final Range TEMPERATURE_RANGE_METRIC = new Range(-20.0, 8.0);
    private static final Range TEMPERATURE_RANGE_ENGLISH = new Range(UnitsConverter.celsiusToFahrenheit(TEMPERATURE_RANGE_METRIC.getLowerBound()), UnitsConverter.celsiusToFahrenheit(TEMPERATURE_RANGE_METRIC.getUpperBound()));
    private static final Range ELEVATION_RANGE_METRIC = new Range(2000.0, 5000.0);
    private static final Range ELEVATION_RANGE_ENGLISH = new Range(UnitsConverter.metersToFeet(ELEVATION_RANGE_METRIC.getLowerBound()), UnitsConverter.metersToFeet(ELEVATION_RANGE_METRIC.getUpperBound()));
    private final Climate _climate;
    private final Climate.ClimateListener _climateListener;
    private final XYSeries _series;
    private final boolean _englishUnits;

    public TemperatureVersusElevationChart(Frame frame, Dimension dimension, Climate climate, boolean bl) {
        super(frame);
        this.setSize(dimension);
        this.setResizable(false);
        this._englishUnits = bl;
        this._climate = climate;
        this._climateListener = new Climate.ClimateAdapter(){

            public void temperatureChanged() {
                TemperatureVersusElevationChart.this.update();
            }
        };
        this._climate.addClimateListener(this._climateListener);
        this._series = new XYSeries((Comparable)((Object)"temperatureVersusElevation"), false);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(this._series);
        String string = bl ? GlaciersStrings.AXIS_TEMPERATURE_FAHRENHEIT : GlaciersStrings.AXIS_TEMPERATURE_CELSIUS;
        String string2 = bl ? GlaciersStrings.AXIS_ELEVATION_ENGLISH : GlaciersStrings.AXIS_ELEVATION_METRIC;
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(GlaciersStrings.TITLE_TEMPERATURE_VERSUS_ELEVATION, string, string2, xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (bl) {
            numberAxis.setRange(TEMPERATURE_RANGE_ENGLISH);
        } else {
            numberAxis.setRange(TEMPERATURE_RANGE_METRIC);
        }
        NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (bl) {
            numberAxis2.setRange(ELEVATION_RANGE_ENGLISH);
        } else {
            numberAxis2.setRange(ELEVATION_RANGE_METRIC);
        }
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseZoomable(false);
        this.setContentPane(chartPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TemperatureVersusElevationChart.this.cleanup();
            }

            public void windowClosed(WindowEvent windowEvent) {
                TemperatureVersusElevationChart.this.cleanup();
            }
        });
        this.update();
    }

    private void cleanup() {
        this._climate.removeClimateListener(this._climateListener);
    }

    private void update() {
        this._series.clear();
        double d = 0.0;
        double d2 = ELEVATION_RANGE_METRIC.getUpperBound();
        for (double d3 = ELEVATION_RANGE_METRIC.getLowerBound(); d3 <= d2; d3 += 100.0) {
            d = this._climate.getTemperature(d3);
            if (this._englishUnits) {
                this._series.add(UnitsConverter.celsiusToFahrenheit(d), UnitsConverter.metersToFeet(d3));
                continue;
            }
            this._series.add(d, d3);
        }
    }
}

