/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.charts;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GlacierLengthVersusTimeChart
extends PaintImmediateDialog {
    private static final Range MIN_LENGTH_RANGE_METRIC = new Range(0.0, 3000.0);
    private static final Range MIN_LENGTH_RANGE_ENGLISH = new Range(UnitsConverter.metersToFeet(MIN_LENGTH_RANGE_METRIC.getLowerBound()), UnitsConverter.metersToFeet(MIN_LENGTH_RANGE_METRIC.getUpperBound()));
    private final Glacier _glacier;
    private final GlaciersClock _clock;
    private final ClockListener _clockListener;
    private final XYSeries _series;
    private final NumberAxis _rangeAxis;
    private final NumberAxis _domainAxis;
    private boolean _englishUnits;

    public GlacierLengthVersusTimeChart(Frame frame, Dimension dimension, Glacier glacier, GlaciersClock glaciersClock, boolean bl) {
        super(frame);
        this.setSize(dimension);
        this.setResizable(false);
        this._englishUnits = bl;
        this._glacier = glacier;
        this._clock = glaciersClock;
        this._clockListener = new ClockAdapter(){

            public void simulationTimeReset(ClockEvent clockEvent) {
                GlacierLengthVersusTimeChart.this._series.clear();
            }

            public void simulationTimeChanged(ClockEvent clockEvent) {
                GlacierLengthVersusTimeChart.this.addSamplePoint();
            }
        };
        this._clock.addClockListener(this._clockListener);
        this._series = new XYSeries((Comparable)((Object)"glacierLengthVersusTime"), false);
        this._series.setMaximumItemCount(1000);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(this._series);
        String string = GlaciersStrings.AXIS_TIME;
        String string2 = bl ? GlaciersStrings.AXIS_GLACIER_LENGTH_ENGLISH : GlaciersStrings.AXIS_GLACIER_LENGTH_METRIC;
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(GlaciersStrings.TITLE_GLACIER_LENGTH_VERSUS_TIME, string, string2, xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        this._domainAxis = (NumberAxis)xYPlot.getDomainAxis();
        this._domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this._rangeAxis = (NumberAxis)xYPlot.getRangeAxis();
        this._rangeAxis.setAutoRange(true);
        this._rangeAxis.setRangeType(RangeType.POSITIVE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseZoomable(false);
        this.setContentPane(chartPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GlacierLengthVersusTimeChart.this.cleanup();
            }

            public void windowClosed(WindowEvent windowEvent) {
                GlacierLengthVersusTimeChart.this.cleanup();
            }
        });
        this.updateYAxis();
        this.addSamplePoint();
    }

    private void cleanup() {
        this._clock.removeClockListener(this._clockListener);
    }

    public void setEnglishUnits(boolean bl) {
        if (bl != this._englishUnits) {
            this._englishUnits = bl;
            this.updateYAxis();
            int n = this._series.getItemCount();
            for (int i = 0; i < n; ++i) {
                XYDataItem xYDataItem = this._series.getDataItem(i);
                if (this._englishUnits) {
                    xYDataItem.setY(UnitsConverter.metersToFeet(xYDataItem.getY().doubleValue()));
                    continue;
                }
                xYDataItem.setY(UnitsConverter.feetToMeters(xYDataItem.getY().doubleValue()));
            }
        }
    }

    private void addSamplePoint() {
        double d = this._clock.getSimulationTime();
        double d2 = this._glacier.getLength();
        if (this._englishUnits) {
            d2 = UnitsConverter.metersToFeet(d2);
        }
        this._series.add(d, d2);
        double d3 = this._series.getDataItem(0).getX().doubleValue();
        this._domainAxis.setRange(new Range(d3, d3 + 1000.0));
    }

    private void updateYAxis() {
        if (this._englishUnits) {
            this._rangeAxis.setLabel(GlaciersStrings.AXIS_GLACIER_LENGTH_ENGLISH);
            this._rangeAxis.setAutoRangeMinimumSize(MIN_LENGTH_RANGE_ENGLISH.getUpperBound());
        } else {
            this._rangeAxis.setLabel(GlaciersStrings.AXIS_GLACIER_LENGTH_METRIC);
            this._rangeAxis.setAutoRangeMinimumSize(MIN_LENGTH_RANGE_METRIC.getUpperBound());
        }
    }
}

