/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.charts;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GlacialBudgetVersusElevationChart
extends PaintImmediateDialog {
    private static final Range GLACIAL_BUDGET_RANGE_METRIC = new Range(-19.0, 19.0);
    private static final Range GLACIAL_BUDGET_RANGE_ENGLISH = new Range(UnitsConverter.metersToFeet(GLACIAL_BUDGET_RANGE_METRIC.getLowerBound()), UnitsConverter.metersToFeet(GLACIAL_BUDGET_RANGE_METRIC.getUpperBound()));
    private static final Range ELEVATION_RANGE_METRIC = new Range(2000.0, 5000.0);
    private static final Range ELEVATION_RANGE_ENGLISH = new Range(UnitsConverter.metersToFeet(ELEVATION_RANGE_METRIC.getLowerBound()), UnitsConverter.metersToFeet(ELEVATION_RANGE_METRIC.getUpperBound()));
    private static final Stroke GLACIAL_BUDGET_STROKE = new BasicStroke(2.0f);
    private static final Stroke ACCUMULATION_STROKE = new BasicStroke(1.0f);
    private static final Stroke ABLATION_STROKE = new BasicStroke(1.0f);
    private static final Stroke NEGATIVE_ABLATION_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private final Climate _climate;
    private final Climate.ClimateListener _climateListener;
    private final XYSeries _glacialBudgetSeries;
    private final XYSeries _accumulationSeries;
    private final XYSeries _ablationSeries;
    private final XYSeries _negativeAblationSeries;
    private final boolean _englishUnits;

    public GlacialBudgetVersusElevationChart(Frame frame, Dimension dimension, Climate climate, boolean bl) {
        super(frame);
        this.setSize(dimension);
        this.setResizable(false);
        this._englishUnits = bl;
        this._climate = climate;
        this._climateListener = new Climate.ClimateListener(){

            public void snowfallChanged() {
                GlacialBudgetVersusElevationChart.this.update();
            }

            public void temperatureChanged() {
                GlacialBudgetVersusElevationChart.this.update();
            }
        };
        this._climate.addClimateListener(this._climateListener);
        this._accumulationSeries = new XYSeries((Comparable)((Object)GlaciersStrings.LABEL_ACCUMULATION), false);
        this._ablationSeries = new XYSeries((Comparable)((Object)GlaciersStrings.LABEL_ABLATION), false);
        this._negativeAblationSeries = new XYSeries((Comparable)((Object)GlaciersStrings.LABEL_NEGATIVE_ABLATION), false);
        this._glacialBudgetSeries = new XYSeries((Comparable)((Object)GlaciersStrings.LABEL_GLACIAL_BUDGET), false);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(this._accumulationSeries);
        xYSeriesCollection.addSeries(this._ablationSeries);
        xYSeriesCollection.addSeries(this._negativeAblationSeries);
        xYSeriesCollection.addSeries(this._glacialBudgetSeries);
        String string = bl ? GlaciersStrings.AXIS_FEET_PER_YEAR : GlaciersStrings.AXIS_METERS_PER_YEAR;
        String string2 = bl ? GlaciersStrings.AXIS_ELEVATION_ENGLISH : GlaciersStrings.AXIS_ELEVATION_METRIC;
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(GlaciersStrings.TITLE_GLACIAL_BUDGET_VERSUS_ELEVATION, string, string2, xYSeriesCollection, PlotOrientation.VERTICAL, true, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setSeriesPaint(0, GlaciersConstants.ACCUMULATION_COLOR);
        xYItemRenderer.setSeriesStroke(0, ACCUMULATION_STROKE);
        xYItemRenderer.setSeriesPaint(1, GlaciersConstants.ABLATION_COLOR);
        xYItemRenderer.setSeriesStroke(1, ABLATION_STROKE);
        xYItemRenderer.setSeriesPaint(2, GlaciersConstants.NEGATIVE_ABLATION_COLOR);
        xYItemRenderer.setSeriesStroke(2, NEGATIVE_ABLATION_STROKE);
        xYItemRenderer.setSeriesPaint(3, GlaciersConstants.GLACIAL_BUDGET_COLOR);
        xYItemRenderer.setSeriesStroke(3, GLACIAL_BUDGET_STROKE);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this._englishUnits) {
            numberAxis.setRange(GLACIAL_BUDGET_RANGE_ENGLISH);
        } else {
            numberAxis.setRange(GLACIAL_BUDGET_RANGE_METRIC);
        }
        NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this._englishUnits) {
            numberAxis2.setRange(ELEVATION_RANGE_ENGLISH);
        } else {
            numberAxis2.setRange(ELEVATION_RANGE_METRIC);
        }
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseZoomable(false);
        this.setContentPane(chartPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GlacialBudgetVersusElevationChart.this.cleanup();
            }

            public void windowClosed(WindowEvent windowEvent) {
                GlacialBudgetVersusElevationChart.this.cleanup();
            }
        });
        this.update();
    }

    private void cleanup() {
        this._climate.removeClimateListener(this._climateListener);
    }

    private void update() {
        this._glacialBudgetSeries.clear();
        this._accumulationSeries.clear();
        this._ablationSeries.clear();
        this._negativeAblationSeries.clear();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = ELEVATION_RANGE_METRIC.getUpperBound();
        for (double d5 = ELEVATION_RANGE_METRIC.getLowerBound(); d5 <= d4; d5 += 100.0) {
            d = this._climate.getGlacialBudget(d5);
            d2 = this._climate.getAccumulation(d5);
            d3 = this._climate.getAblation(d5);
            double d6 = d5;
            if (this._englishUnits) {
                d6 = UnitsConverter.metersToFeet(d6);
                d = UnitsConverter.metersToFeet(d);
                d2 = UnitsConverter.metersToFeet(d2);
                d3 = UnitsConverter.metersToFeet(d3);
            }
            this._glacialBudgetSeries.add(d, d6);
            this._accumulationSeries.add(d2, d6);
            this._ablationSeries.add(d3, d6);
            this._negativeAblationSeries.add(-d3, d6);
        }
    }
}

