/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.module.advanced.AdvancedModule;
import edu.colorado.phet.glaciers.module.intro.IntroModule;
import edu.colorado.phet.glaciers.persistence.AdvancedConfig;
import edu.colorado.phet.glaciers.persistence.GlaciersConfig;
import edu.colorado.phet.glaciers.persistence.IntroConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class GlaciersApplication
extends PiccoloPhetApplication {
    private IntroModule _introModule;
    private AdvancedModule _advancedModule;
    private XMLPersistenceManager _persistenceManager;

    public GlaciersApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this._introModule = new IntroModule(phetFrame);
        this.addModule(this._introModule);
        this._advancedModule = new AdvancedModule(phetFrame);
        this.addModule(this._advancedModule);
    }

    private void initMenubar(String[] stringArray) {
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Glacier Evolution State...");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlaciersApplication.this.setEvolutionStateDialogVisible(jCheckBoxMenuItem.isSelected());
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Model Constants...");
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlaciersApplication.this.setModelConstantsDialogVisible(jCheckBoxMenuItem2.isSelected());
            }
        });
    }

    public void setEvolutionStateDialogVisible(boolean bl) {
        this._introModule.setEvolutionStateDialogVisible(bl);
        this._advancedModule.setEvolutionStateDialogVisible(bl);
    }

    public void setModelConstantsDialogVisible(boolean bl) {
        this._introModule.setModelConstantsDialogVisible(bl);
        this._advancedModule.setModelConstantsDialogVisible(bl);
    }

    public void save() {
        GlaciersConfig glaciersConfig = new GlaciersConfig();
        glaciersConfig.setVersionString(this.getSimInfo().getVersion().toString());
        glaciersConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        glaciersConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        glaciersConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        glaciersConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        IntroConfig introConfig = this._introModule.save();
        glaciersConfig.setBasicConfig(introConfig);
        AdvancedConfig advancedConfig = this._advancedModule.save();
        glaciersConfig.setAdvancedConfig(advancedConfig);
        this._persistenceManager.save(glaciersConfig);
    }

    public void load() {
        Object object = this._persistenceManager.load();
        if (object != null) {
            if (object instanceof GlaciersConfig) {
                GlaciersConfig glaciersConfig = (GlaciersConfig)object;
                IntroConfig introConfig = glaciersConfig.getBasicConfig();
                this._introModule.load(introConfig);
                AdvancedConfig advancedConfig = glaciersConfig.getAdvancedConfig();
                this._advancedModule.load(advancedConfig);
            } else {
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), GlaciersStrings.MESSAGE_NOT_A_CONFIG_FILE);
            }
        }
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "glaciers", GlaciersApplication.class);
    }
}

