/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class LiquidExpansionThermometerNode
extends PComposite {
    private static final Color TUBE_FILL_COLOR = new Color(255, 255, 255, 180);
    private static final Color INNER_WALL_COLOR = Color.WHITE;
    private static final Stroke OUTLINE_STROKE = LiquidExpansionThermometerNode.createAreaStroke(1.0f);
    private static final Color OUTLINE_COLOR = Color.BLACK;
    private static final Color LIQUID_COLOR = PhetColorScheme.RED_COLORBLIND;
    private static final Color TICK_COLOR = Color.BLACK;
    private final double _bulbDiameter;
    private final double _tubeWidth;
    private final double _tubeHeight;
    private final double _tubeMinX;
    private float _innerWallWidth;
    private final Rectangle2D _liquidShape;
    private final PPath _liquidNode;
    private final PNode _ticksNode;
    private final PPath _innerWallNode;
    private final PClip _backgroundNode;
    private final PPath _outlineNode;

    public LiquidExpansionThermometerNode(PDimension pDimension) {
        this(pDimension.getWidth(), 0.5 * pDimension.getWidth(), pDimension.getHeight() - pDimension.getWidth());
    }

    public LiquidExpansionThermometerNode(double d, double d2, double d3) {
        if (d <= d2) {
            throw new IllegalArgumentException("bulbDiameter must be > tubeWidth");
        }
        this._bulbDiameter = d;
        this._tubeWidth = d2;
        this._tubeHeight = d3;
        this._tubeMinX = (d - this._tubeWidth) / 2.0;
        this._liquidShape = new Rectangle2D.Double();
        this._liquidNode = new PPath();
        this._liquidNode.setPaint(LIQUID_COLOR);
        this._liquidNode.setStroke(null);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this._tubeMinX, 0.0, this._tubeWidth, this._bulbDiameter + this._tubeHeight, this._tubeWidth, this._tubeWidth);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, this._tubeHeight, this._bulbDiameter, this._bulbDiameter);
        Area area = new Area();
        area.add(new Area(double_2));
        area.add(new Area(double_));
        this._innerWallWidth = (float)(this._bulbDiameter * 0.15);
        this._innerWallNode = new PPath(area);
        this._innerWallNode.setStroke(LiquidExpansionThermometerNode.createAreaStroke(this._innerWallWidth));
        this._innerWallNode.setStrokePaint(INNER_WALL_COLOR);
        this._innerWallNode.setPaint(null);
        this._backgroundNode = new PClip();
        this._backgroundNode.setPathTo(area);
        this._backgroundNode.setStroke(null);
        this._backgroundNode.setPaint(TUBE_FILL_COLOR);
        this._backgroundNode.addChild(this._liquidNode);
        this._backgroundNode.addChild(this._innerWallNode);
        this._ticksNode = new PComposite();
        this.setTicks(10.0, TICK_COLOR, 1.0f);
        this._outlineNode = new PPath(area);
        this._outlineNode.setStroke(OUTLINE_STROKE);
        this._outlineNode.setStrokePaint(OUTLINE_COLOR);
        this._outlineNode.setPaint(null);
        this.addChild(this._backgroundNode);
        this.addChild(this._outlineNode);
        this.addChild(this._ticksNode);
        this.setLiquidHeight(0.0);
    }

    public void setLiquidHeight(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("percent out of range: " + d);
        }
        double d2 = this._innerWallNode.getVisible() ? this._innerWallWidth : 0.0f;
        double d3 = this._bulbDiameter;
        double d4 = this._bulbDiameter + d * (this._tubeHeight + d2);
        this._liquidShape.setRect(0.0, this._bulbDiameter + this._tubeHeight - d4 + d2, d3, d4);
        this._liquidNode.setPathTo(this._liquidShape);
    }

    public double getBulbDiameter() {
        return this._bulbDiameter;
    }

    public void setInnerWallVisible(boolean bl) {
        this._innerWallNode.setVisible(bl);
    }

    public void setTicks(double d, Paint paint, float f) {
        this._ticksNode.removeAllChildren();
        double d2 = 0.25 * this._tubeWidth;
        BasicStroke basicStroke = new BasicStroke(f);
        for (double d3 = d; d3 < this._tubeHeight; d3 += d) {
            PPath pPath = new PPath(new Line2D.Double(this._tubeMinX, d3, this._tubeMinX + d2, d3));
            pPath.setStroke(basicStroke);
            pPath.setStrokePaint(paint);
            this._ticksNode.addChild(pPath);
        }
    }

    private static Stroke createAreaStroke(float f) {
        return new BasicStroke(f, 2, 1);
    }
}

