/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.model.ModelElementListenerAdapter;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.view.GeneNetworkFontFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class SimpleModelElementNode
extends PPath {
    private static final Font LABEL_FONT = GeneNetworkFontFactory.getFont(14, 1);
    private static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke GHOST_MODE_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 2.0f}, 0.0f);
    private final SimpleModelElement modelElement;
    private final ModelViewTransform2D mvt;
    private PhetPPath centerDot = new PhetPPath(Color.RED, (Stroke)new BasicStroke(2.0f), (Paint)Color.RED);
    private boolean ghostModeEnabled = false;

    public SimpleModelElementNode(final SimpleModelElement simpleModelElement, final ModelViewTransform2D modelViewTransform2D, boolean bl) {
        this.modelElement = simpleModelElement;
        this.mvt = modelViewTransform2D;
        this.setStroke(NORMAL_STROKE);
        simpleModelElement.addListener(new ModelElementListenerAdapter(){

            public void positionChanged() {
                SimpleModelElementNode.this.updateOffset();
            }

            public void shapeChanged() {
                SimpleModelElementNode.this.updateShape();
            }

            public void existenceStrengthChanged() {
                SimpleModelElementNode.this.updatePaintAndStroke(false);
            }
        });
        this.updateShape();
        this.updatePaintAndStroke(false);
        if (bl && simpleModelElement.getHtmlLabel() != null) {
            HTMLNode hTMLNode = new HTMLNode(simpleModelElement.getHtmlLabel());
            hTMLNode.setFont(LABEL_FONT);
            this.scaleLabel(hTMLNode, this.getFullBoundsReference());
            hTMLNode.setOffset(this.getFullBoundsReference().getCenterX() - hTMLNode.getFullBoundsReference().width / 2.0, this.getFullBoundsReference().getCenterY() - hTMLNode.getFullBoundsReference().height / 2.0);
            this.addChild(hTMLNode);
        }
        this.updateOffset();
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                Point2D point2D = modelViewTransform2D.viewToModelDifferential(new Point2D.Double(pInputEvent.getDeltaRelativeTo((PNode)SimpleModelElementNode.this.getParent()).width, pInputEvent.getDeltaRelativeTo((PNode)SimpleModelElementNode.this.getParent()).height));
                simpleModelElement.setPosition(simpleModelElement.getPositionRef().getX() + point2D.getX(), simpleModelElement.getPositionRef().getY() + point2D.getY());
                if (!simpleModelElement.isUserControlled()) {
                    simpleModelElement.setDragging(true);
                }
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Point2D point2D = modelViewTransform2D.viewToModelDifferential(new Point2D.Double(pInputEvent.getDeltaRelativeTo((PNode)SimpleModelElementNode.this.getParent()).width, pInputEvent.getDeltaRelativeTo((PNode)SimpleModelElementNode.this.getParent()).height));
                simpleModelElement.setPosition(simpleModelElement.getPositionRef().getX() + point2D.getX(), simpleModelElement.getPositionRef().getY() + point2D.getY());
                if (!simpleModelElement.isUserControlled()) {
                    simpleModelElement.setDragging(true);
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                simpleModelElement.setDragging(false);
            }
        });
    }

    private void scaleLabel(HTMLNode hTMLNode, PBounds pBounds) {
        hTMLNode.setScale(1.0);
        double d = 0.9;
        double d2 = pBounds.getWidth() * d / hTMLNode.getWidth();
        double d3 = pBounds.getHeight() * d / hTMLNode.getHeight();
        hTMLNode.setScale(Math.min(d2, d3));
    }

    public void setGhostMode(boolean bl) {
        this.ghostModeEnabled = bl;
        this.updatePaintAndStroke(false);
    }

    private void updateOffset() {
        this.setOffset(this.mvt.modelToView(this.modelElement.getPositionRef()));
    }

    private void updateShape() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.mvt.getAffineTransform().getScaleX(), this.mvt.getAffineTransform().getScaleY());
        Shape shape = affineTransform.createTransformedShape(this.modelElement.getShape());
        this.setPathTo(shape);
    }

    private void updatePaintAndStroke(boolean bl) {
        int n = 255;
        if (!bl) {
            n = (int)Math.round(this.modelElement.getExistenceStrength() * 255.0);
        }
        this.setStrokePaint(new Color(0, 0, 0, n));
        if (!this.ghostModeEnabled) {
            Paint paint;
            this.setStroke(NORMAL_STROKE);
            Paint paint2 = paint = this.modelElement.getPaint();
            if (paint instanceof GradientPaint) {
                GradientPaint gradientPaint = (GradientPaint)paint;
                n = (int)Math.round(this.modelElement.getExistenceStrength() * 255.0);
                Color color = new Color(gradientPaint.getColor1().getRed(), gradientPaint.getColor1().getGreen(), gradientPaint.getColor1().getBlue(), n);
                Color color2 = new Color(gradientPaint.getColor2().getRed(), gradientPaint.getColor2().getGreen(), gradientPaint.getColor2().getBlue(), n);
                paint2 = new GradientPaint(gradientPaint.getPoint1(), color, gradientPaint.getPoint2(), color2);
            } else if (paint instanceof Color) {
                Color color = (Color)paint;
                n = (int)Math.round(this.modelElement.getExistenceStrength() * 255.0);
                paint2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            }
            this.setPaint(paint2);
        } else {
            this.setStroke(GHOST_MODE_STROKE);
            this.setPaint(null);
        }
    }
}

