/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.Galactose;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.LacZ;
import edu.colorado.phet.genenetwork.model.MessengerRna;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import edu.colorado.phet.genenetwork.model.TransformationArrow;
import edu.colorado.phet.genenetwork.view.DnaStrandNode;
import edu.colorado.phet.genenetwork.view.GeneNetworkFontFactory;
import edu.colorado.phet.genenetwork.view.SimpleModelElementNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class MacroMoleculeLegend
extends PhetPNode {
    private static final Stroke OUTLINE_STROKE = new BasicStroke(2.0f);
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 220);
    private static final Font TITLE_FONT = GeneNetworkFontFactory.getFont(20, 1);
    private static final ModelViewTransform2D MVT = new ModelViewTransform2D(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0), new Rectangle2D.Double(-3.75, -3.75, 7.5, 7.5), true);
    private PPath background;
    private PText title;
    private ArrayList<LegendEntry> legendEntries = new ArrayList();
    private JButton closeButton;
    private PSwing closePSwing;

    public MacroMoleculeLegend(final IGeneNetworkModelControl iGeneNetworkModelControl, final PhetPCanvas phetPCanvas, boolean bl) {
        phetPCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MacroMoleculeLegend.this.updateLayout(phetPCanvas);
            }
        });
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void legendVisibilityStateChange() {
                MacroMoleculeLegend.this.updateVisibility(iGeneNetworkModelControl);
            }
        });
        this.background = new PhetPPath(BACKGROUND_COLOR, OUTLINE_STROKE, (Paint)Color.BLACK);
        this.addChild(this.background);
        this.title = new PText(GeneNetworkStrings.MACRO_MOLECULE_LEGEND_TITLE);
        this.title.setFont(TITLE_FONT);
        this.addChild(this.title);
        PNode pNode = this.createDnaStrandNode();
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.DNA_LEGEND_CAPTION));
        pNode = new SimpleModelElementNode(new RnaPolymerase(), MVT, false);
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.POLYMERASE_LEGEND_CAPTION));
        pNode = new SimpleModelElementNode(new LacZ(), MVT, false);
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.LAC_Z_LEGEND_CAPTION));
        pNode = new SimpleModelElementNode(new LacI(), MVT, false);
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.LAC_I_LEGEND_CAPTION));
        if (bl) {
            pNode = new SimpleModelElementNode(new LacY(), MVT, false);
            this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.LAC_Y_LEGEND_CAPTION));
        }
        pNode = this.createLactoseNode();
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.LACTOSE_LEGEND_CAPTION));
        MessengerRna messengerRna = new MessengerRna(null, 10.0, false);
        messengerRna.setPredictibleShape();
        pNode = new SimpleModelElementNode(messengerRna, MVT, false);
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.MESSENGER_RNA_LEGEND_CAPTION));
        pNode = new SimpleModelElementNode(new TransformationArrow(null, new Point2D.Double(0.0, 0.0), 5.0, false, 0.0), MVT, false);
        this.legendEntries.add(new LegendEntry(pNode, GeneNetworkStrings.TRANSFORMATION_ARROW_LEGEND_CAPTION));
        for (LegendEntry legendEntry : this.legendEntries) {
            this.background.addChild(legendEntry.getIcon());
            this.background.addChild(legendEntry.getCaption());
        }
        ImageIcon imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png"));
        this.closeButton = new JButton(imageIcon);
        this.closeButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                iGeneNetworkModelControl.setLegendVisible(false);
            }
        });
        this.closePSwing = new PSwing(this.closeButton);
        this.closePSwing.addInputEventListener(new CursorHandler(12));
        this.addChild(this.closePSwing);
        this.updateLayout(phetPCanvas);
        this.updateVisibility(iGeneNetworkModelControl);
    }

    public MacroMoleculeLegend(IGeneNetworkModelControl iGeneNetworkModelControl, PhetPCanvas phetPCanvas) {
        this(iGeneNetworkModelControl, phetPCanvas, false);
    }

    private void updateLayout(JComponent jComponent) {
        double d = 0.0;
        double d2 = 0.0;
        for (LegendEntry legendEntry : this.legendEntries) {
            d = Math.max(legendEntry.getIcon().getFullBoundsReference().getWidth(), d);
            d2 = Math.max(legendEntry.getCaption().getFullBoundsReference().getWidth(), d2);
        }
        double d3 = 16.0 + d + 10.0 + d2;
        double d4 = 8.0 + d / 2.0;
        double d5 = 8.0 + d + 10.0 + d2 / 2.0;
        double d6 = 5.0;
        this.title.setOffset(d3 / 2.0 - this.title.getFullBoundsReference().width / 2.0, d6);
        d3 = Math.max(this.title.getFullBoundsReference().width, d3);
        d6 = this.title.getFullBoundsReference().getMaxY() + 12.0;
        this.closePSwing.setOffset(d3 - this.closePSwing.getFullBoundsReference().width - 4.0, 2.0);
        for (LegendEntry legendEntry : this.legendEntries) {
            double d7 = d6 + legendEntry.getHeight() / 2.0;
            PNode pNode = legendEntry.getIcon();
            pNode.setOffset(0.0, 0.0);
            double d8 = pNode.getFullBoundsReference().getMinX();
            double d9 = pNode.getFullBoundsReference().getWidth();
            double d10 = pNode.getFullBoundsReference().getMinY();
            double d11 = pNode.getFullBoundsReference().getHeight();
            pNode.setOffset(d4 - d9 / 2.0 - d8, d7 - d11 / 2.0 - d10);
            PNode pNode2 = legendEntry.getCaption();
            pNode2.setOffset(d5 - pNode2.getFullBoundsReference().width / 2.0, d7 - pNode2.getFullBoundsReference().height / 2.0);
            d6 = Math.max(pNode.getFullBoundsReference().getMaxY(), pNode2.getFullBoundsReference().getMaxY());
            if (legendEntry == this.legendEntries.get(this.legendEntries.size() - 1)) continue;
            d6 += 14.0;
        }
        this.background.setPathTo(new RoundRectangle2D.Double(0.0, 0.0, d3, d6 + 12.0, 8.0, 8.0));
    }

    private void updateVisibility(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this.setVisible(iGeneNetworkModelControl.isLegendVisible());
    }

    private PNode createLactoseNode() {
        PNode pNode = new PNode();
        SimpleModelElementNode simpleModelElementNode = new SimpleModelElementNode(new Glucose(), MVT, false);
        simpleModelElementNode.setOffset(-simpleModelElementNode.getFullBoundsReference().width / 2.0, 0.0);
        pNode.addChild(simpleModelElementNode);
        SimpleModelElementNode simpleModelElementNode2 = new SimpleModelElementNode(new Galactose(), MVT, false);
        simpleModelElementNode2.setOffset(simpleModelElementNode2.getFullBoundsReference().width / 2.0, 0.0);
        pNode.addChild(simpleModelElementNode2);
        pNode.setPickable(false);
        pNode.setChildrenPickable(false);
        return pNode;
    }

    private PNode createDnaStrandNode() {
        double d = 40.0;
        double d2 = 5.0;
        double d3 = 3.0;
        double d4 = 3.0;
        double d5 = 100.0;
        BasicStroke basicStroke = new BasicStroke(1.0f);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(0.0, 0.0);
        double d6 = Math.PI * 2 * d4 / d5;
        int n = 0;
        while ((double)n < d5) {
            doubleGeneralPath.lineTo((double)n * (d / d5), Math.sin(d6 * (double)n) * d2);
            ++n;
        }
        PNode pNode = new PNode();
        PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)basicStroke, (Paint)DnaStrandNode.STRAND_1_COLOR);
        phetPPath.setOffset(d / 2.0, 0.0);
        pNode.addChild(phetPPath);
        PhetPPath phetPPath2 = new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)basicStroke, (Paint)DnaStrandNode.STRAND_2_COLOR);
        phetPPath2.setOffset(d / 2.0 + d3, 0.0);
        pNode.addChild(phetPPath2);
        pNode.setPickable(false);
        pNode.setChildrenPickable(false);
        return pNode;
    }

    private static class LegendEntry {
        private static final Font LABEL_FONT = GeneNetworkFontFactory.getFont(16, 0);
        private static final Color LABEL_COLOR = Color.BLACK;
        private final PNode icon;
        private final PNode caption;

        public LegendEntry(PNode pNode, String string) {
            this.icon = pNode;
            pNode.setPickable(false);
            this.caption = new HTMLNode(string, LABEL_COLOR, LABEL_FONT);
            this.caption.setPickable(false);
        }

        public PNode getIcon() {
            return this.icon;
        }

        public PNode getCaption() {
            return this.caption;
        }

        public double getHeight() {
            return Math.max(this.icon.getFullBoundsReference().height, this.caption.getFullBoundsReference().height);
        }
    }
}

