/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.LacOperonModel;
import edu.colorado.phet.genenetwork.view.DnaSegmentToolboxWithLacYNode;
import edu.colorado.phet.genenetwork.view.DnaStrandNode;
import edu.colorado.phet.genenetwork.view.GeneNetworkCanvas;
import edu.colorado.phet.genenetwork.view.LactoseInjectorNode;
import edu.colorado.phet.genenetwork.view.LactoseMeter;
import edu.colorado.phet.genenetwork.view.MacroMoleculeLegend;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Rectangle2D;

public class LactoseTransportCanvas
extends GeneNetworkCanvas {
    public LactoseTransportCanvas(LacOperonModel lacOperonModel) {
        super(lacOperonModel);
        Rectangle2D rectangle2D = lacOperonModel.getCellMembraneRect();
        Rectangle2D rectangle2D2 = this.getMvt().createTransformedShape(rectangle2D).getBounds2D();
        GradientPaint gradientPaint = new GradientPaint(0.0f, (float)rectangle2D2.getCenterY(), Color.WHITE, 0.0f, (float)rectangle2D2.getBounds2D().getMaxY(), new Color(255, 100, 100), true);
        PhetPPath phetPPath = new PhetPPath(rectangle2D2, gradientPaint, new BasicStroke(2.0f), Color.BLACK);
        phetPPath.setTransparency(0.7f);
        PText pText = new PText(GeneNetworkStrings.CELL_MEMBRANE_LABEL);
        pText.setFont(new PhetFont(18, true));
        pText.setOffset(this.getMvt().modelToViewXDouble(lacOperonModel.getInteriorMotionBounds().getMinX()), rectangle2D2.getCenterY() - pText.getFullBoundsReference().height / 2.0);
        phetPPath.addChild(pText);
        this.setCellMembraneNode(phetPPath);
        this.setDnaStrand(new DnaStrandNode(lacOperonModel.getDnaStrand(), this.getMvt(), this.getBackground()));
        this.setToolBox(new DnaSegmentToolboxWithLacYNode(this, lacOperonModel, this.getMvt()));
        LactoseInjectorNode lactoseInjectorNode = new LactoseInjectorNode(lacOperonModel, this.getMvt(), 0.0);
        lactoseInjectorNode.setOffset(50.0, phetPPath.getFullBoundsReference().getMinY() - lactoseInjectorNode.getFullBoundsReference().height / 2.0 - 4.0);
        this.setLactoseInjector(lactoseInjectorNode);
        this.setLegend(new MacroMoleculeLegend(lacOperonModel, this, true));
        LactoseMeter lactoseMeter = new LactoseMeter(lacOperonModel);
        lactoseMeter.setOffset(-200.0, 250.0);
        this.setLactoseMeter(lactoseMeter);
    }
}

