/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.Galactose;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.IModelElementListener;
import edu.colorado.phet.genenetwork.model.ModelElementListenerAdapter;
import edu.colorado.phet.genenetwork.view.SimpleModelElementNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class LactoseMeter
extends PhetPNode {
    private static final Dimension2D size = new PDimension(80.0, 245.0);
    private static final PhetFont LABEL_FONT = new PhetFont(14, true);
    private static final Color MAIN_BACKGROUND_COLOR = new Color(255, 255, 204);
    private static float OUTLINE_STROKE_WIDTH = 1.0f;
    private static final Stroke OUTLINE_STROKE = new BasicStroke(OUTLINE_STROKE_WIDTH);
    private static final Color OUTLINE_STROKE_COLOR = Color.BLACK;
    private static final Color BAR_BACKGROUND_COLOR = Color.BLACK;
    private static final Color BAR_COLOR = Color.ORANGE;
    private final IGeneNetworkModelControl model;
    private final PNode background;
    private final PNode barBackground;
    private final PhetPPath bar;
    private final Rectangle2D barShape = new Rectangle2D.Double();
    private final HTMLNode label;
    private final double barWidth;
    private final double maxBarHeight;
    private final JButton closeButton;
    private final PSwing closePSwing;
    private final HTMLNode overflowText;
    private final IModelElementListener glucoseListener = new ModelElementListenerAdapter(){

        public void removedFromModel() {
            LactoseMeter.this.updateBarSize();
        }
    };

    public LactoseMeter(final IGeneNetworkModelControl iGeneNetworkModelControl) {
        this.model = iGeneNetworkModelControl;
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void lactoseLevelChanged() {
                LactoseMeter.this.updateBarSize();
            }

            public void lactoseMeterVisibilityStateChange() {
                LactoseMeter.this.updateVisibility();
            }
        });
        this.background = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight(), 8.0, 8.0), MAIN_BACKGROUND_COLOR, OUTLINE_STROKE, OUTLINE_STROKE_COLOR);
        this.addChild(this.background);
        this.barWidth = size.getWidth() * 0.85;
        this.maxBarHeight = size.getHeight() * 0.5;
        double d = (size.getWidth() - this.barWidth) / 2.0 + (double)(OUTLINE_STROKE_WIDTH / 2.0f);
        ImageIcon imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png"));
        this.closeButton = new JButton(imageIcon);
        this.closeButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                iGeneNetworkModelControl.setLactoseMeterVisible(false);
            }
        });
        this.closePSwing = new PSwing(this.closeButton);
        this.closePSwing.setOffset(size.getWidth() - (double)this.closeButton.getBounds().width - d, d / 2.0);
        this.closePSwing.addInputEventListener(new CursorHandler(12));
        this.addChild(this.closePSwing);
        this.barBackground = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, this.barWidth, this.maxBarHeight), (Paint)BAR_BACKGROUND_COLOR);
        this.barBackground.setOffset(d, this.closePSwing.getFullBoundsReference().getMaxY() + d / 2.0);
        this.addChild(this.barBackground);
        double d2 = size.getHeight() / 40.0;
        ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0), new Rectangle2D.Double(-d2, -d2, d2 * 2.0, d2 * 2.0), true);
        PNode pNode = this.createLactoseNode(modelViewTransform2D);
        pNode.setOffset(size.getWidth() / 2.0, this.barBackground.getFullBoundsReference().getMaxY() + pNode.getFullBoundsReference().height / 2.0 + d);
        this.addChild(pNode);
        this.label = new HTMLNode(GeneNetworkStrings.LACTOSE_METER_CAPTION, Color.BLACK, LABEL_FONT);
        this.addChild(this.label);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, pNode.getFullBoundsReference().getMaxY(), size.getWidth() - 2.0 * d, size.getHeight() - pNode.getFullBoundsReference().getMaxY() - d);
        double d3 = Math.min(((RectangularShape)double_).getWidth() / this.label.getWidth(), ((RectangularShape)double_).getHeight() / this.label.getHeight());
        this.label.setScale(d3);
        this.label.setOffset(double_.getCenterX() - this.label.getFullBoundsReference().width / 2.0, double_.getCenterY() - this.label.getFullBoundsReference().height / 2.0);
        this.bar = new PhetPPath(BAR_COLOR);
        this.bar.setOffset((size.getWidth() - this.barWidth) / 2.0 + (double)(OUTLINE_STROKE_WIDTH / 2.0f), 0.0);
        this.addChild(this.bar);
        this.overflowText = new HTMLNode(GeneNetworkStrings.OFF_CHART);
        this.overflowText.setFont(LABEL_FONT);
        this.overflowText.setHTMLColor(Color.BLUE);
        this.overflowText.setScale((this.barWidth - d * 2.0) / this.overflowText.getFullBoundsReference().getWidth());
        this.overflowText.setOffset(size.getWidth() / 2.0 - this.overflowText.getFullBoundsReference().getWidth() / 2.0, this.barBackground.getOffset().getY() + d);
        this.overflowText.setVisible(false);
        this.addChild(this.overflowText);
        for (Glucose glucose : iGeneNetworkModelControl.getGlucoseList()) {
            glucose.addListener(this.glucoseListener);
        }
        this.updateBarSize();
        this.updateVisibility();
    }

    private void updateBarSize() {
        double d;
        if ((double)this.model.getLactoseLevel() > 50.0) {
            d = this.maxBarHeight;
            this.overflowText.setVisible(true);
        } else {
            d = (double)this.model.getLactoseLevel() / 50.0 * this.maxBarHeight;
            if (this.overflowText.getVisible()) {
                this.overflowText.setVisible(false);
            }
        }
        this.barShape.setFrame(0.0, 0.0, this.barWidth, d);
        this.bar.setPathTo(this.barShape);
        this.bar.setOffset(this.bar.getOffset().getX(), this.barBackground.getBoundsReference().getMaxY() - d + this.barBackground.getOffset().getY());
    }

    private void updateVisibility() {
        this.setVisible(this.model.isLactoseMeterVisible());
    }

    private PNode createLactoseNode(ModelViewTransform2D modelViewTransform2D) {
        PNode pNode = new PNode();
        SimpleModelElementNode simpleModelElementNode = new SimpleModelElementNode(new Glucose(), modelViewTransform2D, false);
        simpleModelElementNode.setOffset(-simpleModelElementNode.getFullBoundsReference().width / 2.0, 0.0);
        pNode.addChild(simpleModelElementNode);
        SimpleModelElementNode simpleModelElementNode2 = new SimpleModelElementNode(new Galactose(), modelViewTransform2D, false);
        simpleModelElementNode2.setOffset(simpleModelElementNode2.getFullBoundsReference().width / 2.0, 0.0);
        pNode.addChild(simpleModelElementNode2);
        pNode.setPickable(false);
        pNode.setChildrenPickable(false);
        return pNode;
    }
}

