/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkConstants;
import edu.colorado.phet.genenetwork.model.Galactose;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.LacOperonModel;
import edu.colorado.phet.genenetwork.model.MessengerRna;
import edu.colorado.phet.genenetwork.model.ModelElementListenerAdapter;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.TransformationArrow;
import edu.colorado.phet.genenetwork.module.LacOperonDefaults;
import edu.colorado.phet.genenetwork.view.DnaSegmentToolBoxNode;
import edu.colorado.phet.genenetwork.view.DnaStrandNode;
import edu.colorado.phet.genenetwork.view.LactoseInjectorNode;
import edu.colorado.phet.genenetwork.view.LactoseMeter;
import edu.colorado.phet.genenetwork.view.MacroMoleculeLegend;
import edu.colorado.phet.genenetwork.view.SimpleModelElementNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GeneNetworkCanvas
extends PhetPCanvas {
    private static final Dimension INITIAL_INTERMEDIATE_DIMENSION = new Dimension(786, 786);
    private final ModelViewTransform2D mvt;
    private final PNode cellularFluidLayer;
    private final PNode toolBoxLayer;
    private final PNode dnaStrandLayer;
    private final PNode backmostRovingModelElementLayer;
    private final PNode middleRovingModelElementLayer;
    private final PNode frontmostRovingModelElementLayer;
    private final PNode lactoseInjectorLayer;
    private final PNode cellMembraneLayer;
    private final PNode legendLayer;
    private MacroMoleculeLegend legend;
    private LactoseMeter lactoseMeter;
    private LactoseInjectorNode lactoseInjector;
    private DnaStrandNode dnaStrand;
    private DnaSegmentToolBoxNode toolBox;
    private PNode cellMembraneNode;

    public GeneNetworkCanvas(LacOperonModel lacOperonModel) {
        super(LacOperonDefaults.VIEW_SIZE);
        this.setBackground(GeneNetworkConstants.CANVAS_BACKGROUND);
        this.setWorldTransformStrategy(new PhetPCanvas.CenterWidthScaleHeight(this, INITIAL_INTERMEDIATE_DIMENSION));
        this.mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point(393, (int)Math.round(432.3)), 7.0, true);
        lacOperonModel.addListener(new GeneNetworkModelAdapter(){

            public void modelElementAdded(SimpleModelElement simpleModelElement) {
                GeneNetworkCanvas.this.addModelElement(simpleModelElement);
            }
        });
        this.cellularFluidLayer = new PNode();
        this.addWorldChild(this.cellularFluidLayer);
        this.toolBoxLayer = new PNode();
        this.addScreenChild(this.toolBoxLayer);
        this.dnaStrandLayer = new PNode();
        this.addWorldChild(this.dnaStrandLayer);
        this.backmostRovingModelElementLayer = new PNode();
        this.addWorldChild(this.backmostRovingModelElementLayer);
        this.middleRovingModelElementLayer = new PNode();
        this.addWorldChild(this.middleRovingModelElementLayer);
        this.frontmostRovingModelElementLayer = new PNode();
        this.addWorldChild(this.frontmostRovingModelElementLayer);
        this.lactoseInjectorLayer = new PNode();
        this.addWorldChild(this.lactoseInjectorLayer);
        this.cellMembraneLayer = new PNode();
        this.addWorldChild(this.cellMembraneLayer);
        this.legendLayer = new PNode();
        this.addScreenChild(this.legendLayer);
        for (SimpleModelElement simpleModelElement : lacOperonModel.getAllSimpleModelElements()) {
            this.addModelElement(simpleModelElement);
        }
    }

    protected ModelViewTransform2D getMvt() {
        return this.mvt;
    }

    protected void setToolBox(DnaSegmentToolBoxNode dnaSegmentToolBoxNode) {
        if (this.toolBox != null) {
            this.toolBoxLayer.removeChild(this.toolBox);
        }
        this.toolBoxLayer.addChild(dnaSegmentToolBoxNode);
        this.toolBox = dnaSegmentToolBoxNode;
    }

    protected void setCellMembraneNode(PNode pNode) {
        if (this.cellMembraneNode != null) {
            this.cellMembraneLayer.removeChild(this.cellMembraneNode);
        }
        this.cellMembraneLayer.addChild(pNode);
        this.cellMembraneNode = pNode;
        this.cellularFluidLayer.removeAllChildren();
        double d = 2358.0;
        double d2 = 786.0;
        PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, d, d2), (Paint)new Color(204, 255, 249));
        phetPPath.setOffset(393.0 - d / 2.0, pNode.getFullBoundsReference().getMinY() - d2);
        this.cellularFluidLayer.addChild(phetPPath);
    }

    protected void setLegend(MacroMoleculeLegend macroMoleculeLegend) {
        if (this.legend != null) {
            this.legendLayer.removeChild(this.legend);
        }
        this.legendLayer.addChild(macroMoleculeLegend);
        this.legend = macroMoleculeLegend;
    }

    protected void setLactoseMeter(LactoseMeter lactoseMeter) {
        if (this.lactoseMeter != null) {
            this.lactoseInjectorLayer.removeChild(this.lactoseMeter);
        }
        this.lactoseInjectorLayer.addChild(lactoseMeter);
        this.lactoseMeter = lactoseMeter;
    }

    protected void setLactoseInjector(LactoseInjectorNode lactoseInjectorNode) {
        if (this.lactoseInjector != null) {
            this.lactoseInjectorLayer.removeChild(this.lactoseInjector);
        }
        this.lactoseInjectorLayer.addChild(lactoseInjectorNode);
        this.lactoseInjector = lactoseInjectorNode;
    }

    protected void setDnaStrand(DnaStrandNode dnaStrandNode) {
        if (this.dnaStrand != null) {
            this.dnaStrandLayer.removeChild(this.dnaStrand);
        }
        this.dnaStrandLayer.addChild(dnaStrandNode);
        this.dnaStrand = dnaStrandNode;
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
        this.legend.setOffset((double)this.getWidth() - this.legend.getFullBoundsReference().getWidth() - 10.0, 10.0);
    }

    private void addModelElement(SimpleModelElement simpleModelElement) {
        final SimpleModelElementNode simpleModelElementNode = new SimpleModelElementNode(simpleModelElement, this.mvt, true);
        if (simpleModelElement.isPartOfDnaStrand()) {
            this.dnaStrandLayer.addChild(simpleModelElementNode);
        } else if (simpleModelElement instanceof Glucose || simpleModelElement instanceof Galactose) {
            this.backmostRovingModelElementLayer.addChild(simpleModelElementNode);
        } else if (simpleModelElement instanceof RnaPolymerase) {
            this.frontmostRovingModelElementLayer.addChild(simpleModelElementNode);
        } else {
            this.middleRovingModelElementLayer.addChild(simpleModelElementNode);
            if (simpleModelElement instanceof MessengerRna || simpleModelElement instanceof TransformationArrow) {
                simpleModelElementNode.setPickable(false);
            }
        }
        simpleModelElement.addListener(new ModelElementListenerAdapter(){

            public void removedFromModel() {
                if (GeneNetworkCanvas.this.backmostRovingModelElementLayer.getChildrenReference().contains(simpleModelElementNode)) {
                    GeneNetworkCanvas.this.backmostRovingModelElementLayer.removeChild(simpleModelElementNode);
                } else if (GeneNetworkCanvas.this.middleRovingModelElementLayer.getChildrenReference().contains(simpleModelElementNode)) {
                    GeneNetworkCanvas.this.middleRovingModelElementLayer.removeChild(simpleModelElementNode);
                } else if (GeneNetworkCanvas.this.frontmostRovingModelElementLayer.getChildrenReference().contains(simpleModelElementNode)) {
                    GeneNetworkCanvas.this.frontmostRovingModelElementLayer.removeChild(simpleModelElementNode);
                } else if (GeneNetworkCanvas.this.dnaStrandLayer.getChildrenReference().contains(simpleModelElementNode)) {
                    GeneNetworkCanvas.this.dnaStrandLayer.removeChild(simpleModelElementNode);
                }
            }
        });
    }
}

