/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.module;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.phetcommon.view.clock.SimSpeedControl;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.GeneNetworkClock;
import edu.colorado.phet.genenetwork.model.LacOperonModel;
import edu.colorado.phet.genenetwork.view.GeneNetworkCanvas;
import edu.colorado.phet.genenetwork.view.LactoseRegulationCanvas;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LacOperonModule
extends PiccoloModule {
    private LacOperonModel model;
    private GeneNetworkCanvas canvas;

    public LacOperonModule(Frame frame) {
        super(GeneNetworkStrings.TITLE_LACTOSE_REGULATION, new GeneNetworkClock(25, 0.04));
        GeneNetworkClock geneNetworkClock = (GeneNetworkClock)this.getClock();
        this.model = new LacOperonModel(geneNetworkClock, false);
        this.canvas = new LactoseRegulationCanvas(this.model);
        this.setSimulationPanel(this.canvas);
        this.setLogoPanel(null);
        PiccoloClockControlPanel piccoloClockControlPanel = new PiccoloClockControlPanel(this.getClock());
        final SimSpeedControl simSpeedControl = new SimSpeedControl(0.008, 0.08, (ConstantDtClock)this.getClock(), null);
        simSpeedControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ConstantDtClock)LacOperonModule.this.getClock()).setDt(simSpeedControl.getValue());
            }
        });
        piccoloClockControlPanel.addBetweenTimeDisplayAndButtons(simSpeedControl);
        JPanel jPanel = new JPanel();
        jPanel.add(piccoloClockControlPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalStrut(30));
        jPanel.add(jPanel2);
        jPanel.add(new ResetAllButton(this, (Component)jPanel));
        this.setClockControlPanel(jPanel);
        if (this.hasHelp()) {
            // empty if block
        }
    }

    public void reset() {
        GeneNetworkClock geneNetworkClock = this.model.getClock();
        geneNetworkClock.resetSimulationTime();
        this.model.reset();
    }
}

