/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TransformationArrow
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = Color.BLACK;
    private static double WIDTH = 0.5;
    private static double HEAD_WIDTH = 2.0;
    private static double HEAD_HEIGHT = 2.0;
    private static double EXISTENCE_TIME = 0.01;
    private final double pointingAngle;

    public TransformationArrow(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, double d, boolean bl, double d2) {
        super(iGeneNetworkModelControl, TransformationArrow.createShape(d, d2), point2D, ELEMENT_PAINT, bl, EXISTENCE_TIME);
        this.pointingAngle = d2;
    }

    private static Shape createShape(double d, double d2) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-WIDTH / 2.0, -d / 2.0);
        doubleGeneralPath.lineTo(WIDTH / 2.0, -d / 2.0);
        doubleGeneralPath.lineTo(WIDTH / 2.0, d / 2.0 - HEAD_HEIGHT);
        doubleGeneralPath.lineTo(HEAD_WIDTH / 2.0, d / 2.0 - HEAD_HEIGHT);
        doubleGeneralPath.lineTo(0.0, d / 2.0);
        doubleGeneralPath.lineTo(-HEAD_WIDTH / 2.0, d / 2.0 - HEAD_HEIGHT);
        doubleGeneralPath.lineTo(-WIDTH / 2.0, d / 2.0 - HEAD_HEIGHT);
        doubleGeneralPath.closePath();
        Area area = new Area(doubleGeneralPath.getGeneralPath());
        double d3 = (d - HEAD_HEIGHT) / 5.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(-WIDTH / 2.0, -d / 2.0 + d3, WIDTH, d3);
        area.subtract(new Area(double_));
        Rectangle2D.Double double_2 = new Rectangle2D.Double(-WIDTH / 2.0, -d / 2.0 + d3 * 3.0, WIDTH, d3);
        area.subtract(new Area(double_2));
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d2 - 1.5707963267948966);
        return affineTransform.createTransformedShape(area);
    }

    protected double getPointingAngle() {
        return this.pointingAngle;
    }

    protected double getHeadHeight() {
        return HEAD_HEIGHT;
    }
}

