/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class SimpleSugar
extends SimpleModelElement {
    private static final double SIDE_LENGTH = 1.0 / Math.sin(1.0471975511965976);

    public SimpleSugar(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, Paint paint) {
        super(iGeneNetworkModelControl, SimpleSugar.createShape(), point2D, paint, false, Double.POSITIVE_INFINITY);
    }

    public static Shape createShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-SIDE_LENGTH / 2.0, -1.0);
        double d = Math.PI;
        for (int i = 0; i < 6; ++i) {
            d = SimpleSugar.lineToRelative(doubleGeneralPath, SIDE_LENGTH, d);
        }
        return AffineTransform.getTranslateInstance(-doubleGeneralPath.getGeneralPath().getBounds2D().getCenterX(), -doubleGeneralPath.getGeneralPath().getBounds2D().getCenterY()).createTransformedShape(doubleGeneralPath.getGeneralPath());
    }

    public static double getSideLength() {
        return SIDE_LENGTH;
    }

    public static double getWidth() {
        return SimpleSugar.getSideLength() * (1.0 + 2.0 * Math.cos(1.0471975511965976));
    }

    private static double lineToRelative(DoubleGeneralPath doubleGeneralPath, double d, double d2) {
        doubleGeneralPath.lineToRelative(Vector2D.parseAngleAndMagnitude(d, d2));
        return d2 + 1.0471975511965976;
    }
}

