/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.Cap;
import edu.colorado.phet.genenetwork.model.DetachFromDnaThenRandomMotionWalkStrategy;
import edu.colorado.phet.genenetwork.model.DirectedRandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.DnaStrand;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacIPromoter;
import edu.colorado.phet.genenetwork.model.LacPromoter;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MessengerRna;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.Promoter;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.SpawnLacIStrategy;
import edu.colorado.phet.genenetwork.model.SpawnLacYAndLacZStrategy;
import edu.colorado.phet.genenetwork.model.SpawnLacYStrategy;
import edu.colorado.phet.genenetwork.model.SpawnLacZStrategy;
import edu.colorado.phet.genenetwork.model.StillnessMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Random;

public class RnaPolymerase
extends SimpleModelElement {
    private static float WIDTH = 5.0f + LacPromoter.WIDTH;
    private static float HEIGHT = 8.0f;
    private static final Paint ELEMENT_PAINT = new GradientPaint(new Point2D.Double(-WIDTH, 0.0), new Color(0, 153, 210), new Point2D.Double(WIDTH * 5.0f, 0.0), Color.WHITE);
    private static Dimension2D LAC_PROMOTER_ATTACHMENT_POINT_OFFSET = new PDimension((double)WIDTH * 0.15, (double)(-HEIGHT) * 0.3);
    private static double RECOVERY_TIME = 7.0;
    private static double MAX_TRAVERSAL_TIME = 15.0;
    private static double TRAVERSAL_SPEED = 5.0;
    private static Random RAND = new Random();
    private Promoter promoterAttachmentPartner = null;
    private Promoter previousPromoterAttachmentPartner = null;
    private AttachmentState promoterAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private Point2D targetPositionForLacPromoterAttachment = new Point2D.Double();
    private double recoveryCountdownTimer;
    private boolean traversing = false;
    private boolean transcribing = false;
    private Point2D traversalStartPt = new Point2D.Double();
    private MessengerRna mRna = null;
    private boolean clearedToCrossLacOperator;
    private int reattachCount;
    private boolean touchedLacIGene = false;
    private boolean touchedLacYGene = false;
    private boolean touchedLacZGene = false;

    public RnaPolymerase(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D) {
        super(iGeneNetworkModelControl, RnaPolymerase.createActiveConformationShape(), point2D, ELEMENT_PAINT, false, Double.POSITIVE_INFINITY);
        if (iGeneNetworkModelControl != null) {
            this.setMotionStrategy(new DirectedRandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            this.setDragBounds(this.getModel().getInteriorMotionBounds());
        }
    }

    public RnaPolymerase(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this(iGeneNetworkModelControl, new Point2D.Double());
    }

    public RnaPolymerase() {
        this(null);
    }

    public void stepInTime(double d) {
        if (!this.isUserControlled() && this.promoterAttachmentState == AttachmentState.UNATTACHED_BUT_UNAVALABLE) {
            if (this.traversing) {
                DnaStrand dnaStrand = this.getModel().getDnaStrand();
                if (this.transcribing) {
                    this.mRna.grow(this.getVelocityRef().getMagnitude() * d);
                    if (this.touchedLacIGene && !dnaStrand.isOnLacIGeneSpace(this.getLeftEdgePoint())) {
                        this.mRna.setSpawningStrategy(new SpawnLacIStrategy());
                        this.freeMessengerRna();
                        this.detachFromDna(0.25, new Vector2D(2.0, 2.0));
                    } else if (this.touchedLacZGene && !this.touchedLacYGene && !dnaStrand.isOnLacZGeneSpace(this.getLeftEdgePoint())) {
                        if (dnaStrand.isOnLacYGeneSpace(this.getPositionRef()) && dnaStrand.isLacYGeneInPlace()) {
                            this.touchedLacYGene = true;
                        } else {
                            this.mRna.setSpawningStrategy(new SpawnLacZStrategy());
                            this.freeMessengerRna();
                            this.detachFromDna(0.25, new Vector2D(2.0, 2.0));
                        }
                    } else if (this.touchedLacYGene && !dnaStrand.isOnLacYGeneSpace(this.getPositionRef()) && !dnaStrand.isOnLacYGeneSpace(this.getLeftEdgePoint())) {
                        if (this.touchedLacZGene) {
                            this.mRna.setSpawningStrategy(new SpawnLacYAndLacZStrategy());
                        } else {
                            this.mRna.setSpawningStrategy(new SpawnLacYStrategy());
                        }
                        this.freeMessengerRna();
                        this.detachFromDna(0.25, new Vector2D(2.0, 2.0));
                    } else if (dnaStrand.isOnLacIGeneSpace(this.getLeftEdgePoint()) && !dnaStrand.isLacIGeneInPlace() || this.touchedLacZGene && dnaStrand.isOnLacZGeneSpace(this.getLeftEdgePoint()) && !dnaStrand.isLacZGeneInPlace() || this.touchedLacYGene && dnaStrand.isOnLacYGeneSpace(this.getLeftEdgePoint()) && !dnaStrand.isLacYGeneInPlace()) {
                        this.freeMessengerRna();
                        this.detachFromDna(0.0);
                    }
                } else {
                    Point2D.Double double_ = new Point2D.Double(this.getPositionRef().getX() + this.getShape().getBounds2D().getMaxX(), this.getPositionRef().getY());
                    if (!this.clearedToCrossLacOperator && dnaStrand.isOnLacOperatorSpace(double_)) {
                        if (this.getModel().isLacIAttachedToDna()) {
                            if (RAND.nextDouble() > (double)this.reattachCount / 6.0) {
                                this.promoterAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                                if (!this.previousPromoterAttachmentPartner.requestReattach(this)) {
                                    this.detachFromDna(0.0, new Vector2D(-2.0, 2.0));
                                    this.reattachCount = 0;
                                } else {
                                    ++this.reattachCount;
                                }
                            } else {
                                this.detachFromDna(0.0, new Vector2D(-2.0, 2.0));
                                this.reattachCount = 0;
                            }
                        } else {
                            this.clearedToCrossLacOperator = true;
                            this.reattachCount = 0;
                        }
                    } else if (dnaStrand.isOnLacZGeneSpace(this.getLeftEdgePoint())) {
                        if (dnaStrand.isLacZGeneInPlace()) {
                            this.mRna = new MessengerRna(this.getModel(), 0.0, false);
                            this.mRna.setPosition(this.getLeftEdgePoint().getX(), this.getLeftEdgePoint().getY());
                            this.getModel().addMessengerRna(this.mRna);
                            this.transcribing = true;
                            this.touchedLacZGene = true;
                        } else if (!dnaStrand.isLacYGeneInPlace()) {
                            this.detachFromDna(0.0);
                        }
                    } else if (dnaStrand.isOnLacYGeneSpace(this.getLeftEdgePoint())) {
                        if (dnaStrand.isLacYGeneInPlace()) {
                            this.mRna = new MessengerRna(this.getModel(), 0.0, false);
                            this.mRna.setPosition(this.getLeftEdgePoint().getX(), this.getLeftEdgePoint().getY());
                            this.getModel().addMessengerRna(this.mRna);
                            this.transcribing = true;
                            this.touchedLacYGene = true;
                        } else {
                            this.detachFromDna(0.0);
                        }
                    } else if (dnaStrand.isOnLacIGeneSpace(this.getLeftEdgePoint())) {
                        if (dnaStrand.isLacIGeneInPlace()) {
                            this.mRna = new MessengerRna(this.getModel(), 0.0, false);
                            this.mRna.setPosition(this.getLeftEdgePoint().getX(), this.getLeftEdgePoint().getY());
                            this.getModel().addMessengerRna(this.mRna);
                            this.transcribing = true;
                            this.touchedLacIGene = true;
                        } else {
                            this.detachFromDna(0.0);
                        }
                    }
                }
            } else {
                this.recoveryCountdownTimer -= d;
                if (this.recoveryCountdownTimer <= 0.0) {
                    this.promoterAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                }
            }
        }
        super.stepInTime(d);
    }

    private void freeMessengerRna() {
        this.mRna.setMotionStrategy(new LinearMotionStrategy(this.getModel().getInteriorMotionBounds(), this.mRna.getPositionRef(), new Vector2D(0.0, 4.0), 20.0));
        this.mRna.setSpawningEnabled(true);
        this.mRna = null;
    }

    private Point2D getLeftEdgePoint() {
        return new Point2D.Double(this.getPositionRef().getX() + this.getShape().getBounds2D().getMinX(), this.getPositionRef().getY());
    }

    public void setDragging(boolean bl) {
        if (this.isUserControlled() != bl) {
            if (bl) {
                if (this.promoterAttachmentPartner != null) {
                    this.promoterAttachmentPartner.detach(this);
                    this.promoterAttachmentPartner = null;
                    this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
                }
                if (this.traversing) {
                    this.setMotionStrategy(new RandomWalkMotionStrategy(this.getModel().getInteriorMotionBoundsAboveDna()));
                    if (this.transcribing) {
                        this.freeMessengerRna();
                    }
                    this.traversing = false;
                    this.transcribing = false;
                }
            } else {
                this.promoterAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                LacIPromoter lacIPromoter = this.getModel().getLacIPromoter();
                LacPromoter lacPromoter = this.getModel().getLacPromoter();
                if (lacIPromoter != null && this.getPositionRef().distance(lacIPromoter.getPositionRef()) < 8.0) {
                    lacIPromoter.requestImmediateAttach(this);
                } else if (lacPromoter != null && this.getPositionRef().distance(lacPromoter.getPositionRef()) < 8.0) {
                    lacPromoter.requestImmediateAttach(this);
                }
            }
        }
        super.setDragging(bl);
    }

    public Point2D getLacPromoterAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + LAC_PROMOTER_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + LAC_PROMOTER_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public void attach(Promoter promoter) {
        if (promoter != this.promoterAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Attachment request from non-partner.");
            assert (false);
            return;
        }
        this.setMotionStrategy(new StillnessMotionStrategy());
        this.setPosition(this.targetPositionForLacPromoterAttachment);
        this.promoterAttachmentState = AttachmentState.ATTACHED;
        this.clearedToCrossLacOperator = false;
    }

    public void detach(Promoter promoter) {
        if (promoter != this.promoterAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Attachment request from non-partner.");
            assert (false);
            return;
        }
        if (this.promoterAttachmentState == AttachmentState.ATTACHED) {
            this.traversing = true;
            this.traversalStartPt.setLocation(this.getPositionRef());
            this.setMotionStrategy(new LinearMotionStrategy(this.getModel().getInteriorMotionBounds(), this.getPositionRef(), new Vector2D(TRAVERSAL_SPEED, 0.0), MAX_TRAVERSAL_TIME));
            this.promoterAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        } else if (this.promoterAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
            this.promoterAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
        }
        this.previousPromoterAttachmentPartner = this.promoterAttachmentPartner;
        this.promoterAttachmentPartner = null;
    }

    private void detachFromDna(double d, Vector2D vector2D) {
        this.transcribing = false;
        this.traversing = false;
        this.touchedLacIGene = false;
        this.touchedLacYGene = false;
        this.touchedLacZGene = false;
        this.setMotionStrategy(new DetachFromDnaThenRandomMotionWalkStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), d, vector2D, 2.0));
        this.recoveryCountdownTimer = RECOVERY_TIME;
    }

    private void detachFromDna(double d) {
        this.detachFromDna(d, null);
    }

    private static Shape createActiveConformationShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(WIDTH / 2.0f, -HEIGHT / 2.0f);
        generalPath.lineTo(0.0f, -HEIGHT / 2.0f);
        generalPath.lineTo(-WIDTH * 0.4f, 0.0f);
        generalPath.curveTo(0.0f, HEIGHT * 0.6f, WIDTH / 4.0f, HEIGHT * 0.4f, WIDTH / 2.0f, HEIGHT / 4.0f);
        generalPath.closePath();
        Area area = new Area(generalPath);
        Shape shape = new LacPromoter(null).getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(generalPath.getBounds2D().getMaxX() - shape.getBounds().getMaxX(), -HEIGHT / 2.0f);
        shape = affineTransform.createTransformedShape(shape);
        area.subtract(new Area(shape));
        Shape shape2 = new Cap(null).getShape();
        affineTransform = new AffineTransform();
        affineTransform.setToTranslation(shape.getBounds2D().getMinX() - shape2.getBounds2D().getWidth() / 2.0, -2.0);
        shape2 = affineTransform.createTransformedShape(shape2);
        area.subtract(new Area(shape2));
        return area;
    }

    public boolean considerProposalFrom(Promoter promoter) {
        boolean bl = false;
        if (this.promoterAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE) {
            assert (this.promoterAttachmentPartner == null);
            this.promoterAttachmentPartner = promoter;
            bl = true;
            this.promoterAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
            double d = this.promoterAttachmentPartner.getAttachmentPointLocation(this).getX() - LAC_PROMOTER_ATTACHMENT_POINT_OFFSET.getWidth();
            double d2 = this.promoterAttachmentPartner.getAttachmentPointLocation(this).getY() - LAC_PROMOTER_ATTACHMENT_POINT_OFFSET.getHeight();
            this.targetPositionForLacPromoterAttachment.setLocation(d, d2);
            if (this.getPositionRef().distance(this.targetPositionForLacPromoterAttachment) > 10.0) {
                this.setMotionStrategy(new DirectedRandomWalkMotionStrategy(this.getModel().getInteriorMotionBounds()));
                this.getMotionStrategyRef().setDestination(d, d2);
            } else {
                this.setMotionStrategy(new LinearMotionStrategy(this.getModel().getInteriorMotionBounds(), this.getPositionRef(), this.targetPositionForLacPromoterAttachment, 3.0));
            }
        }
        return bl;
    }

    public boolean isAvailableForAttaching() {
        return this.promoterAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && !this.isUserControlled();
    }
}

