/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public abstract class Promoter
extends SimpleModelElement {
    private static float HEIGHT = 2.5f;
    public static float WIDTH = 10.0f;
    private static final Dimension2D RNA_POLYMERASE_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, HEIGHT / 2.0f);
    protected RnaPolymerase rnaPolymeraseAttachmentPartner = null;
    protected AttachmentState rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    protected double rnaPolymeraseAttachmentCountdownTimer;
    protected double recoveryCountdownTimer;
    protected double attachmentRecoveryTime = 3.0;

    public Promoter(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, Paint paint, boolean bl, double d) {
        super(iGeneNetworkModelControl, Promoter.createShape(), new Point2D.Double(), paint, false, Double.POSITIVE_INFINITY);
    }

    public void stepInTime(double d) {
        if (!this.isUserControlled()) {
            switch (this.rnaPolymeraseAttachmentState) {
                case UNATTACHED_AND_AVAILABLE: {
                    this.attemptToStartAttaching();
                    break;
                }
                case MOVING_TOWARDS_ATTACHMENT: {
                    this.checkAttachmentCompleted();
                    break;
                }
                case ATTACHED: {
                    this.checkReadyToDetach(d);
                    break;
                }
                case UNATTACHED_BUT_UNAVALABLE: {
                    this.checkIfReadyToAttach(d);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            super.stepInTime(d);
        }
    }

    public boolean requestReattach(RnaPolymerase rnaPolymerase) {
        boolean bl = false;
        if (this.rnaPolymeraseAttachmentPartner == null && this.rnaPolymeraseAttachmentState == AttachmentState.UNATTACHED_BUT_UNAVALABLE) {
            if (rnaPolymerase.considerProposalFrom(this)) {
                this.rnaPolymeraseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.rnaPolymeraseAttachmentPartner = rnaPolymerase;
                bl = true;
            } else assert (false);
        }
        return bl;
    }

    public boolean requestImmediateAttach(RnaPolymerase rnaPolymerase) {
        boolean bl = false;
        if (this.rnaPolymeraseAttachmentState != AttachmentState.ATTACHED) {
            if (this.rnaPolymeraseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT && this.rnaPolymeraseAttachmentPartner != rnaPolymerase) {
                this.rnaPolymeraseAttachmentPartner.detach(this);
                this.rnaPolymeraseAttachmentPartner = null;
                this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            }
            if (!rnaPolymerase.considerProposalFrom(this)) {
                System.err.println(this.getClass().getName() + "- Error: Proposal refused by element that requested attachment.");
                assert (false);
            }
            this.rnaPolymeraseAttachmentPartner = rnaPolymerase;
            this.completeAttachmentOfRnaPolymerase();
            bl = true;
        }
        return bl;
    }

    public void setDragging(boolean bl) {
        if (bl && this.rnaPolymeraseAttachmentPartner != null) {
            this.rnaPolymeraseAttachmentPartner.detach(this);
            this.rnaPolymeraseAttachmentPartner = null;
            this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
        super.setDragging(bl);
    }

    public Point2D getAttachmentPointLocation(RnaPolymerase rnaPolymerase) {
        return new Point2D.Double(this.getPositionRef().getX() + RNA_POLYMERASE_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + RNA_POLYMERASE_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public void detach(RnaPolymerase rnaPolymerase) {
        assert (rnaPolymerase == this.rnaPolymeraseAttachmentPartner);
        this.rnaPolymeraseAttachmentPartner = null;
        this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        this.recoveryCountdownTimer = this.attachmentRecoveryTime;
    }

    public boolean isPartOfDnaStrand() {
        return true;
    }

    protected void setAttachmentRecoveryTime(double d) {
        this.attachmentRecoveryTime = d;
    }

    protected void attemptToStartAttaching() {
        if (!this.isOkayToAttachToRnaPoly()) {
            this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        } else {
            assert (this.rnaPolymeraseAttachmentPartner == null);
            RnaPolymerase rnaPolymerase = this.getModel().getNearestFreeRnaPolymerase(this.getPositionRef());
            if (rnaPolymerase != null && rnaPolymerase.considerProposalFrom(this)) {
                this.rnaPolymeraseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.rnaPolymeraseAttachmentPartner = rnaPolymerase;
            }
        }
    }

    protected boolean isOkayToAttachToRnaPoly() {
        return true;
    }

    protected void checkAttachmentCompleted() {
        assert (this.rnaPolymeraseAttachmentPartner != null);
        if (this.isOkayToAttachToRnaPoly()) {
            Point2D.Double double_ = new Point2D.Double(this.getPositionRef().getX() + RNA_POLYMERASE_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + RNA_POLYMERASE_ATTACHMENT_POINT_OFFSET.getHeight());
            if (double_.distance(this.rnaPolymeraseAttachmentPartner.getLacPromoterAttachmentPointLocation()) < 1.0) {
                this.completeAttachmentOfRnaPolymerase();
            }
        } else {
            this.rnaPolymeraseAttachmentPartner.detach(this);
            this.rnaPolymeraseAttachmentPartner = null;
            this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        }
    }

    private void completeAttachmentOfRnaPolymerase() {
        this.rnaPolymeraseAttachmentPartner.attach(this);
        this.rnaPolymeraseAttachmentState = AttachmentState.ATTACHED;
        this.rnaPolymeraseAttachmentCountdownTimer = 0.5;
    }

    protected void checkReadyToDetach(double d) {
        assert (this.rnaPolymeraseAttachmentPartner != null);
        this.rnaPolymeraseAttachmentCountdownTimer -= d;
        if (this.rnaPolymeraseAttachmentCountdownTimer <= 0.0) {
            this.rnaPolymeraseAttachmentPartner.detach(this);
            this.rnaPolymeraseAttachmentPartner = null;
            this.recoveryCountdownTimer = this.attachmentRecoveryTime;
            this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        }
    }

    private void checkIfReadyToAttach(double d) {
        this.recoveryCountdownTimer -= d;
        if (this.recoveryCountdownTimer < 0.0) {
            if (this.isOkayToAttachToRnaPoly()) {
                this.rnaPolymeraseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            } else {
                this.recoveryCountdownTimer = 0.0;
            }
        }
    }

    private static Shape createShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(WIDTH / 2.0f, HEIGHT / 2.0f);
        generalPath.lineTo(WIDTH / 2.0f, -HEIGHT / 2.0f);
        generalPath.lineTo(-WIDTH / 2.0f, -HEIGHT / 2.0f);
        generalPath.lineTo(-WIDTH / 2.0f, HEIGHT / 2.0f);
        generalPath.lineTo(-WIDTH / 4.0f, 0.0f);
        generalPath.lineTo(0.0f, HEIGHT / 2.0f);
        generalPath.lineTo(WIDTH / 4.0f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }
}

