/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.MessengerRnaSpawningStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.SpawnNothingStrategy;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessengerRna
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = Color.BLACK;
    private static float THICKNESS = 0.5f;
    private static float GROWTH_SEGMENT_LENGTH = 3.0f;
    private static final Random RAND = new Random();
    private double length = 0.0;
    private ArrayList<Point2D> points = new ArrayList();
    private MessengerRnaSpawningStrategy spawningStrategy = new SpawnNothingStrategy();
    private boolean spawningEnabled = false;

    public MessengerRna(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, double d, boolean bl) {
        super(iGeneNetworkModelControl, MessengerRna.createInitialShape(), point2D, ELEMENT_PAINT, bl, Double.POSITIVE_INFINITY);
        while (this.length < d) {
            this.grow(GROWTH_SEGMENT_LENGTH);
        }
    }

    public MessengerRna(IGeneNetworkModelControl iGeneNetworkModelControl, double d, boolean bl) {
        this(iGeneNetworkModelControl, new Point2D.Double(0.0, 0.0), d, bl);
    }

    public void setSpawningEnabled(boolean bl) {
        this.spawningEnabled = bl;
    }

    public void setSpawningStrategy(MessengerRnaSpawningStrategy messengerRnaSpawningStrategy) {
        assert (messengerRnaSpawningStrategy != null);
        this.spawningStrategy = messengerRnaSpawningStrategy;
    }

    public void grow(double d) {
        if (this.length == 0.0) {
            assert (this.points.size() == 0);
            this.points.add(new Point2D.Double(0.0, 0.0));
        } else if (this.points.size() == 0) {
            double[] dArray = new double[6];
            Object object = this.getShape().getPathIterator(new AffineTransform());
            while (!object.isDone()) {
                object.currentSegment(dArray);
                this.points.add(new Point2D.Double(dArray[0], dArray[1]));
                object.next();
            }
            assert (this.points.size() % 2 == 0);
            object = new ArrayList();
            for (int i = 0; i < this.points.size() / 2; ++i) {
                ((ArrayList)object).add(new Point2D.Double(this.points.get(i).getX(), this.points.get(i).getY() - (double)(THICKNESS / 2.0f)));
            }
            this.points = object;
        }
        double d2 = 1.5 * (RAND.nextDouble() - 0.3) * d;
        for (Point2D point2D : this.points) {
            point2D.setLocation(point2D.getX(), point2D.getY() + d2);
        }
        Point2D point2D = this.points.get(this.points.size() - 1);
        this.points.add(new Point2D.Double(point2D.getX() + d, 0.0));
        this.setShape(MessengerRna.createPathFromPoints(this.points).getGeneralPath());
        this.length += d;
    }

    public void setPredictibleShape() {
        this.points = new ArrayList();
        double d = this.length;
        this.length = 0.0;
        RAND.setSeed(3L);
        while (this.length < d) {
            this.grow(GROWTH_SEGMENT_LENGTH);
        }
        RAND.setSeed(System.currentTimeMillis());
    }

    @Override
    public void stepInTime(double d) {
        if (this.spawningEnabled) {
            this.spawningStrategy.stepInTime(d, this);
            if (this.spawningStrategy.isSpawningComplete()) {
                this.setExistenceTime(0.0);
                this.spawningEnabled = false;
            }
        }
        super.stepInTime(d);
    }

    private static Shape createInitialShape() {
        return new Ellipse2D.Double(-THICKNESS / 2.0f, -THICKNESS / 2.0f, THICKNESS, THICKNESS);
    }

    private static DoubleGeneralPath createPathFromPoints(ArrayList<Point2D> arrayList) {
        int n;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(arrayList.get(0));
        for (n = 1; n < arrayList.size(); ++n) {
            doubleGeneralPath.lineTo(arrayList.get(n).getX(), arrayList.get(n).getY() + (double)(THICKNESS / 2.0f));
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            doubleGeneralPath.lineTo(arrayList.get(n).getX(), arrayList.get(n).getY() - (double)(THICKNESS / 2.0f));
        }
        doubleGeneralPath.closePath();
        return doubleGeneralPath;
    }
}

