/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.Promoter;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LacPromoter
extends Promoter {
    private static final Paint ELEMENT_PAINT = new Color(0, 153, 255);

    public LacPromoter(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D) {
        super(iGeneNetworkModelControl, point2D, ELEMENT_PAINT, false, Double.POSITIVE_INFINITY);
        this.setAttachmentRecoveryTime(8.0);
    }

    public LacPromoter(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this(iGeneNetworkModelControl, new Point2D.Double());
    }

    public LacPromoter() {
        this(null, new Point2D.Double());
    }

    public boolean isInContactWithRnaPolymerase() {
        boolean bl = false;
        Rectangle2D rectangle2D = this.getCompensatedBounds();
        for (RnaPolymerase rnaPolymerase : this.getModel().getRnaPolymeraseList()) {
            if (!rnaPolymerase.getCompensatedBounds().intersects(rectangle2D)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isInAllowableLocation() {
        return this.getPositionRef().distance(this.getModel().getDnaStrand().getLacPromoterLocation()) < 5.0;
    }

    protected Point2D getDefaultLocation() {
        return this.getModel().getDnaStrand().getLacPromoterLocation();
    }

    protected boolean isOkayToAttachToRnaPoly() {
        return this.getModel().getGlucoseList().size() > 0 || this.getModel().getLacIList().size() == 0 || this.getModel().getLacOperator() == null || this.getModel().getLacOperator().isLacIAttached();
    }
}

