/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.DnaStrandWithLacY;
import edu.colorado.phet.genenetwork.model.GeneNetworkClock;
import edu.colorado.phet.genenetwork.model.LacOperonModel;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LacOperonModelWithLacY
extends LacOperonModel {
    private static final Point2D CELL_MEMBRANE_CENTER_POS = new Point2D.Double(0.0, 40.0);
    private static final Rectangle2D CELL_MEMBRANE_RECT = new Rectangle2D.Double(-140.0, CELL_MEMBRANE_CENTER_POS.getY() - 2.0, 280.0, 4.0);
    private static final double MIN_DISTANCE_BETWEEN_LAC_Y = new LacY().getShape().getBounds2D().getWidth() * 1.1;

    public LacOperonModelWithLacY(GeneNetworkClock geneNetworkClock, boolean bl) {
        super(geneNetworkClock, bl);
        this.setDnaStrand(new DnaStrandWithLacY(this, DNA_STRAND_SIZE, DNA_STRAND_POSITION));
    }

    public Rectangle2D getCellMembraneRect() {
        return new Rectangle2D.Double(CELL_MEMBRANE_RECT.getX(), CELL_MEMBRANE_RECT.getY(), CELL_MEMBRANE_RECT.getWidth(), CELL_MEMBRANE_RECT.getHeight());
    }

    public Rectangle2D getInteriorMotionBounds() {
        Rectangle2D rectangle2D = super.getInteriorMotionBounds();
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), CELL_MEMBRANE_RECT.getMinY() - rectangle2D.getY());
    }

    public Rectangle2D getInteriorMotionBoundsAboveDna() {
        Rectangle2D rectangle2D = super.getInteriorMotionBoundsAboveDna();
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), CELL_MEMBRANE_RECT.getMinY() - rectangle2D.getY());
    }

    public Rectangle2D getExteriorMotionBounds() {
        Rectangle2D rectangle2D = super.getInteriorMotionBounds();
        return new Rectangle2D.Double(rectangle2D.getX(), CELL_MEMBRANE_RECT.getMaxY(), rectangle2D.getWidth(), rectangle2D.getMaxY() - CELL_MEMBRANE_RECT.getMaxY());
    }

    public PositionWrtCell classifyPosWrtCell(Point2D point2D) {
        if (point2D.getY() < CELL_MEMBRANE_RECT.getMinY()) {
            return PositionWrtCell.INSIDE_CELL;
        }
        if (point2D.getY() > CELL_MEMBRANE_RECT.getMaxY()) {
            return PositionWrtCell.OUTSIDE_CELL;
        }
        return PositionWrtCell.WITHIN_CELL_MEMBRANE;
    }

    public Point2D getOpenSpotForLacY() {
        double d = CELL_MEMBRANE_RECT.getCenterY();
        double d2 = 0.0;
        double d3 = CELL_MEMBRANE_RECT.getCenterX() - 30.0;
        double d4 = this.getInteriorMotionBounds().getMaxX() - 10.0 - d3;
        boolean bl = false;
        double d5 = MIN_DISTANCE_BETWEEN_LAC_Y;
        for (int i = 0; i < 10; ++i) {
            block1: for (int j = 0; j < 100 && !bl; ++j) {
                d2 = d3 + d4 / 2.0 * (this.createBoundedGaussian() + 1.0);
                bl = true;
                for (LacY lacY : this.getLacYList()) {
                    if (!(Math.abs(lacY.getMembraneDestinationRef().getX() - d2) < d5)) continue;
                    bl = false;
                    continue block1;
                }
            }
        }
        if (!bl) {
            double d6 = d3;
            double d7 = d3;
            double d8 = Double.POSITIVE_INFINITY;
            for (LacY lacY : this.getLacYList()) {
                double d9 = Math.abs(lacY.getMembraneDestinationRef().getX() - d6);
                if (!(d9 < d8)) continue;
                d8 = d9;
                d7 = d6 + d8;
            }
            for (LacY lacY : this.getLacYList()) {
                double d10;
                LacY lacY2 = null;
                for (LacY lacY3 : this.getLacYList()) {
                    if (lacY3 == lacY || !(lacY3.getMembraneDestinationRef().getX() > lacY.getMembraneDestinationRef().getX()) || lacY2 != null && !(lacY3.getMembraneDestinationRef().getX() < lacY2.getMembraneDestinationRef().getX())) continue;
                    lacY2 = lacY3;
                }
                double d11 = lacY2 != null ? lacY2.getMembraneDestinationRef().getX() : d3 + d4;
                if (!(d11 - (d10 = lacY.getPositionRef().getX()) > d7 - d6)) continue;
                d6 = d10;
                d7 = d11;
            }
            if (d6 == 0.0 && d7 == 0.0) {
                System.err.println(this.getClass().getName() + " - Error: Algorithm for finding largest free segment failed.");
                assert (false);
                d7 = d3 + d4;
            }
            d2 = d6 + (d7 - d6) / 2.0;
        }
        return new Point2D.Double(d2, d);
    }

    private double createBoundedGaussian() {
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        while (d < -1.0 || d > 1.0) {
            d = RAND.nextGaussian() / 2.0;
            ++n;
        }
        return d;
    }
}

