/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.genenetwork.model.Cap;
import edu.colorado.phet.genenetwork.model.CapBindingRegion;
import edu.colorado.phet.genenetwork.model.DnaStrand;
import edu.colorado.phet.genenetwork.model.Galactose;
import edu.colorado.phet.genenetwork.model.GeneNetworkClock;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelListener;
import edu.colorado.phet.genenetwork.model.IModelElement;
import edu.colorado.phet.genenetwork.model.InjectionMotionStrategy;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LacIGene;
import edu.colorado.phet.genenetwork.model.LacIPromoter;
import edu.colorado.phet.genenetwork.model.LacOperator;
import edu.colorado.phet.genenetwork.model.LacPromoter;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.LacYGene;
import edu.colorado.phet.genenetwork.model.LacZ;
import edu.colorado.phet.genenetwork.model.LacZGene;
import edu.colorado.phet.genenetwork.model.MessengerRna;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.TransformationArrow;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LacOperonModel
implements IGeneNetworkModelControl {
    private static final Rectangle2D MODEL_BOUNDS = new Rectangle2D.Double(-70.0, -60.0, 140.0, 120.0);
    protected static final Random RAND = new Random();
    protected static final Dimension2D DNA_STRAND_SIZE = new PDimension(182.0, 1.5);
    protected static final Point2D DNA_STRAND_POSITION = new Point2D.Double(0.0, -20.0);
    private static final Rectangle2D MOTION_BOUNDS = new Rectangle2D.Double(MODEL_BOUNDS.getMinX(), DNA_STRAND_POSITION.getY(), MODEL_BOUNDS.getWidth(), MODEL_BOUNDS.getHeight() - DNA_STRAND_POSITION.getY() + MODEL_BOUNDS.getMinY());
    private static final Rectangle2D MOTION_BOUNDS_ABOVE_DNA = new Rectangle2D.Double(MODEL_BOUNDS.getMinX(), DNA_STRAND_POSITION.getY() + 1.5 + 10.0, MODEL_BOUNDS.getWidth(), MODEL_BOUNDS.getMaxY() - (DNA_STRAND_POSITION.getY() + 1.5 + 10.0));
    private final GeneNetworkClock clock;
    protected ArrayList<IGeneNetworkModelListener> listeners = new ArrayList();
    private DnaStrand dnaStrand = new DnaStrand(this, DNA_STRAND_SIZE, DNA_STRAND_POSITION);
    private final ArrayList<LacI> lacIList = new ArrayList();
    private final ArrayList<LacZ> lacZList = new ArrayList();
    private final ArrayList<LacY> lacYList = new ArrayList();
    private final ArrayList<Glucose> glucoseList = new ArrayList();
    private final ArrayList<Galactose> galactoseList = new ArrayList();
    private final ArrayList<RnaPolymerase> rnaPolymeraseList = new ArrayList();
    private final ArrayList<MessengerRna> messengerRnaList = new ArrayList();
    private final ArrayList<TransformationArrow> transformationArrowList = new ArrayList();
    private Cap cap = null;
    private CapBindingRegion capBindingRegion = null;
    private LacOperator lacOperator = null;
    private LacIGene lacIGene = null;
    private LacZGene lacZGene = null;
    private LacYGene lacYGene = null;
    private LacIPromoter lacIPromoter = null;
    private LacPromoter lacPromoter = null;
    private Rectangle2D toolBoxRect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private boolean lactoseInjectionAllowed = false;
    private boolean automaticLactoseInjectionEnabled = false;
    private double automaticLactoseInjectionCountdown = 0.0;
    private Point2D automaticLactoseInjectionPoint = new Point2D.Double();
    private Vector2D automaticLactoseInjectionVelocity = new Vector2D();
    private boolean isLegendVisible = false;
    private boolean isLactoseMeterVisible = false;
    private final Timer delayedLactoseInjectionEnableTimer = new Timer(3000, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LacOperonModel.this.setLactoseInjectionAllowed(true);
            LacOperonModel.this.delayedLactoseInjectionEnableTimer.stop();
        }
    });
    int lactoseLevel;

    public LacOperonModel(GeneNetworkClock geneNetworkClock, boolean bl) {
        this.clock = geneNetworkClock;
        geneNetworkClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                LacOperonModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.addInitialModelElements();
    }

    public void reset() {
        this.removeElementsFromModel(this.lacIList);
        this.removeElementsFromModel(this.lacZList);
        this.removeElementsFromModel(this.lacYList);
        this.removeElementsFromModel(this.glucoseList);
        this.removeElementsFromModel(this.galactoseList);
        this.removeElementsFromModel(this.rnaPolymeraseList);
        this.removeElementsFromModel(this.messengerRnaList);
        this.removeElementsFromModel(this.transformationArrowList);
        if (this.cap != null) {
            this.cap.removeFromModel();
            this.cap = null;
        }
        if (this.capBindingRegion != null) {
            this.capBindingRegion.removeFromModel();
            this.capBindingRegion = null;
        }
        if (this.lacOperator != null) {
            this.lacOperator.removeFromModel();
            this.lacOperator = null;
        }
        if (this.lacIGene != null) {
            this.lacIGene.removeFromModel();
            this.lacIGene = null;
        }
        if (this.lacZGene != null) {
            this.lacZGene.removeFromModel();
            this.lacZGene = null;
        }
        if (this.lacYGene != null) {
            this.lacYGene.removeFromModel();
            this.lacYGene = null;
        }
        if (this.lacIPromoter != null) {
            this.lacIPromoter.removeFromModel();
            this.lacIPromoter = null;
        }
        if (this.lacPromoter != null) {
            this.lacPromoter.removeFromModel();
            this.lacPromoter = null;
        }
        this.setLactoseInjectionAllowed(false);
        this.setAutomaticLactoseInjectionEnabled(false);
        this.setLegendVisible(false);
        this.setLactoseMeterVisible(false);
        this.addInitialModelElements();
    }

    @Override
    public ArrayList<LacI> getLacIList() {
        return this.lacIList;
    }

    @Override
    public ArrayList<LacZ> getLacZList() {
        return this.lacZList;
    }

    @Override
    public ArrayList<LacY> getLacYList() {
        return this.lacYList;
    }

    @Override
    public ArrayList<Glucose> getGlucoseList() {
        return this.glucoseList;
    }

    @Override
    public ArrayList<RnaPolymerase> getRnaPolymeraseList() {
        return this.rnaPolymeraseList;
    }

    @Override
    public LacOperator getLacOperator() {
        return this.lacOperator;
    }

    @Override
    public LacIGene getLacIGene() {
        return this.lacIGene;
    }

    @Override
    public LacZGene getLacZGene() {
        return this.lacZGene;
    }

    @Override
    public LacYGene getLacYGene() {
        return this.lacYGene;
    }

    @Override
    public LacIPromoter getLacIPromoter() {
        return this.lacIPromoter;
    }

    @Override
    public LacPromoter getLacPromoter() {
        return this.lacPromoter;
    }

    @Override
    public void setToolBoxRect(Rectangle2D rectangle2D) {
        this.toolBoxRect.setFrame(rectangle2D);
    }

    @Override
    public Glucose getNearestLactose(Point2D point2D, PositionWrtCell positionWrtCell, boolean bl) {
        assert (positionWrtCell != null);
        assert (positionWrtCell != PositionWrtCell.WITHIN_CELL_MEMBRANE);
        double d = Double.POSITIVE_INFINITY;
        Glucose glucose = null;
        for (Glucose glucose2 : this.glucoseList) {
            if (!glucose2.isBoundToGalactose() || bl && !glucose2.isAvailableForAttaching() || !(point2D.distance(glucose2.getPositionRef()) < d) || this.classifyPosWrtCell(glucose2.getPositionRef()) != positionWrtCell) continue;
            glucose = glucose2;
            d = point2D.distance(glucose2.getPositionRef());
        }
        return glucose;
    }

    @Override
    public LacI getNearestFreeLacI(Point2D point2D) {
        double d = Double.POSITIVE_INFINITY;
        LacI lacI = null;
        for (LacI lacI2 : this.lacIList) {
            if (!lacI2.isAvailableForAttaching() || !(point2D.distance(lacI2.getPositionRef()) < d)) continue;
            lacI = lacI2;
            d = point2D.distance(lacI2.getPositionRef());
        }
        return lacI;
    }

    @Override
    public RnaPolymerase getNearestFreeRnaPolymerase(Point2D point2D) {
        double d = Double.POSITIVE_INFINITY;
        RnaPolymerase rnaPolymerase = null;
        for (RnaPolymerase rnaPolymerase2 : this.rnaPolymeraseList) {
            if (!rnaPolymerase2.isAvailableForAttaching() || !(point2D.distance(rnaPolymerase2.getPositionRef()) < d)) continue;
            rnaPolymerase = rnaPolymerase2;
            d = point2D.distance(rnaPolymerase2.getPositionRef());
        }
        return rnaPolymerase;
    }

    @Override
    public boolean isLactoseInjectionAllowed() {
        return this.lactoseInjectionAllowed;
    }

    public void setLactoseInjectionAllowed(boolean bl) {
        this.delayedLactoseInjectionEnableTimer.stop();
        if (bl != this.lactoseInjectionAllowed) {
            this.lactoseInjectionAllowed = bl;
            this.notifyLactoseInjectionAllowedStateChange();
        }
    }

    @Override
    public void setAutomaticLactoseInjectionEnabled(boolean bl) {
        if (this.automaticLactoseInjectionEnabled != bl) {
            this.automaticLactoseInjectionEnabled = bl;
            this.notifyAutomaticLactoseInjectionEnabledStateChange();
            if (bl) {
                this.automaticLactoseInjectionCountdown = 0.0;
            }
        }
    }

    @Override
    public boolean isAutomaticLactoseInjectionEnabled() {
        return this.automaticLactoseInjectionEnabled;
    }

    @Override
    public void setAutomaticLactoseInjectionParams(Point2D point2D, Vector2D vector2D) {
        this.automaticLactoseInjectionPoint.setLocation(point2D);
        this.automaticLactoseInjectionVelocity.setComponents(vector2D.getX(), vector2D.getY());
    }

    public void startLactoseInjectionAllowedTimer() {
        if (!this.lactoseInjectionAllowed && !this.delayedLactoseInjectionEnableTimer.isRunning()) {
            this.delayedLactoseInjectionEnableTimer.restart();
        }
    }

    @Override
    public void setLegendVisible(boolean bl) {
        if (bl != this.isLegendVisible) {
            this.isLegendVisible = bl;
            this.notifyLegendVisibilityStateChange();
        }
    }

    @Override
    public boolean isLegendVisible() {
        return this.isLegendVisible;
    }

    @Override
    public void setLactoseMeterVisible(boolean bl) {
        if (bl != this.isLactoseMeterVisible) {
            this.isLactoseMeterVisible = bl;
            this.notifyLactoseMeterVisibilityStateChange();
        }
    }

    @Override
    public boolean isLactoseMeterVisible() {
        return this.isLactoseMeterVisible;
    }

    @Override
    public boolean isPointInToolBox(Point2D point2D) {
        return this.toolBoxRect.contains(point2D);
    }

    private void addInitialModelElements() {
        for (int i = 0; i < 2; ++i) {
            RnaPolymerase rnaPolymerase = new RnaPolymerase(this);
            this.randomlyInitModelElement(rnaPolymerase);
            this.rnaPolymeraseList.add(rnaPolymerase);
            this.notifyModelElementAdded(rnaPolymerase);
        }
    }

    public GeneNetworkClock getClock() {
        return this.clock;
    }

    @Override
    public Rectangle2D getCellMembraneRect() {
        return null;
    }

    @Override
    public Rectangle2D getInteriorMotionBoundsAboveDna() {
        return MOTION_BOUNDS_ABOVE_DNA;
    }

    @Override
    public Rectangle2D getInteriorMotionBounds() {
        return MOTION_BOUNDS;
    }

    @Override
    public Rectangle2D getExteriorMotionBounds() {
        return null;
    }

    @Override
    public boolean isLacIAttachedToDna() {
        if (this.lacOperator == null) {
            return false;
        }
        return this.lacOperator.isLacIAttached();
    }

    @Override
    public DnaStrand getDnaStrand() {
        return this.dnaStrand;
    }

    protected void setDnaStrand(DnaStrand dnaStrand) {
        this.dnaStrand = dnaStrand;
    }

    private void randomlyInitModelElement(SimpleModelElement simpleModelElement) {
        simpleModelElement.setPosition((RAND.nextDouble() - 0.5) * 70.0, RAND.nextDouble() / 2.0 * 60.0);
        double d = 2.0;
        simpleModelElement.setVelocity((RAND.nextDouble() - 0.5) * d, (RAND.nextDouble() - 0.5) * d);
    }

    public ArrayList<SimpleModelElement> getAllSimpleModelElements() {
        ArrayList<SimpleModelElement> arrayList = new ArrayList<SimpleModelElement>();
        arrayList.addAll(this.rnaPolymeraseList);
        arrayList.addAll(this.lacIList);
        arrayList.addAll(this.lacZList);
        arrayList.addAll(this.lacYList);
        arrayList.addAll(this.glucoseList);
        arrayList.addAll(this.galactoseList);
        arrayList.addAll(this.messengerRnaList);
        arrayList.addAll(this.transformationArrowList);
        if (this.cap != null) {
            arrayList.add(this.cap);
        }
        if (this.capBindingRegion != null) {
            arrayList.add(this.capBindingRegion);
        }
        if (this.lacOperator != null) {
            arrayList.add(this.lacOperator);
        }
        if (this.lacIGene != null) {
            arrayList.add(this.lacIGene);
        }
        if (this.lacYGene != null) {
            arrayList.add(this.lacYGene);
        }
        if (this.lacZGene != null) {
            arrayList.add(this.lacZGene);
        }
        if (this.lacIPromoter != null) {
            arrayList.add(this.lacIPromoter);
        }
        if (this.lacPromoter != null) {
            arrayList.add(this.lacPromoter);
        }
        return arrayList;
    }

    @Override
    public void addMessengerRna(MessengerRna messengerRna) {
        this.messengerRnaList.add(messengerRna);
        this.notifyModelElementAdded(messengerRna);
    }

    @Override
    public void addTransformationArrow(TransformationArrow transformationArrow) {
        this.transformationArrowList.add(transformationArrow);
        this.notifyModelElementAdded(transformationArrow);
    }

    @Override
    public void addLacZ(LacZ lacZ) {
        this.lacZList.add(lacZ);
        this.notifyModelElementAdded(lacZ);
        this.startLactoseInjectionAllowedTimer();
    }

    @Override
    public void addLacY(LacY lacY) {
        this.lacYList.add(lacY);
        this.notifyModelElementAdded(lacY);
        this.startLactoseInjectionAllowedTimer();
    }

    @Override
    public void addLacI(LacI lacI) {
        this.lacIList.add(lacI);
        this.notifyModelElementAdded(lacI);
        this.startLactoseInjectionAllowedTimer();
    }

    @Override
    public LacZGene createAndAddLacZGene(Point2D point2D) {
        assert (this.lacZGene == null);
        this.lacZGene = new LacZGene(this, point2D);
        this.notifyModelElementAdded(this.lacZGene);
        return this.lacZGene;
    }

    @Override
    public LacYGene createAndAddLacYGene(Point2D point2D) {
        assert (this.lacYGene == null);
        this.lacYGene = new LacYGene(this, point2D);
        this.notifyModelElementAdded(this.lacYGene);
        return this.lacYGene;
    }

    @Override
    public LacIGene createAndAddLacIGene(Point2D point2D) {
        assert (this.lacIGene == null);
        this.lacIGene = new LacIGene(this, point2D);
        this.notifyModelElementAdded(this.lacIGene);
        return this.lacIGene;
    }

    @Override
    public LacOperator createAndAddLacOperator(Point2D point2D) {
        assert (this.lacOperator == null);
        this.lacOperator = new LacOperator(this, point2D);
        this.notifyModelElementAdded(this.lacOperator);
        return this.lacOperator;
    }

    @Override
    public LacPromoter createAndAddLacPromoter(Point2D point2D) {
        assert (this.lacPromoter == null);
        this.lacPromoter = new LacPromoter(this, point2D);
        this.notifyModelElementAdded(this.lacPromoter);
        return this.lacPromoter;
    }

    @Override
    public LacIPromoter createAndAddLacIPromoter(Point2D point2D) {
        assert (this.lacIPromoter == null);
        this.lacIPromoter = new LacIPromoter(this, point2D);
        this.notifyModelElementAdded(this.lacIPromoter);
        return this.lacIPromoter;
    }

    @Override
    public void createAndAddLactose(Point2D point2D, Vector2D vector2D) {
        Glucose glucose = new Glucose(this);
        double d = glucose.getShape().getBounds2D().getWidth() / 2.0;
        glucose.setPosition(point2D.getX() - d, point2D.getY());
        Galactose galactose = new Galactose(this);
        if (this.classifyPosWrtCell(point2D) == PositionWrtCell.INSIDE_CELL) {
            glucose.setMotionStrategy(new InjectionMotionStrategy(MotionBoundsTrimmer.trim(this.getInteriorMotionBoundsAboveDna(), glucose), vector2D));
            glucose.setUpDraggableBounds(PositionWrtCell.INSIDE_CELL);
        } else {
            glucose.setMotionStrategy(new InjectionMotionStrategy(MotionBoundsTrimmer.trim(this.getExteriorMotionBounds(), glucose), vector2D));
            glucose.setUpDraggableBounds(PositionWrtCell.OUTSIDE_CELL);
        }
        glucose.formLactose(galactose);
        this.galactoseList.add(galactose);
        this.notifyModelElementAdded(galactose);
        this.glucoseList.add(glucose);
        this.notifyModelElementAdded(glucose);
    }

    private void stepInTime(double d) {
        this.stepElementsInTime(this.lacZList, d);
        this.stepElementsInTime(this.lacIList, d);
        this.stepElementsInTime(this.lacYList, d);
        this.stepElementsInTime(this.glucoseList, d);
        this.stepElementsInTime(this.galactoseList, d);
        this.stepElementsInTime(this.rnaPolymeraseList, d);
        this.stepElementsInTime(this.messengerRnaList, d);
        this.stepElementsInTime(this.transformationArrowList, d);
        int n = 0;
        for (Glucose glucose : this.glucoseList) {
            if (!glucose.isBoundToGalactose() || this.classifyPosWrtCell(glucose.getPositionRef()) != PositionWrtCell.INSIDE_CELL) continue;
            ++n;
        }
        if (this.lactoseLevel != n) {
            this.lactoseLevel = n;
            this.notifyLactoseLevelChanged();
        }
        if (this.cap != null) {
            this.cap.stepInTime(d);
        }
        if (this.capBindingRegion != null) {
            if (this.capBindingRegion.getExistenceStrength() == 0.0) {
                this.capBindingRegion.removeFromModel();
                this.capBindingRegion = null;
            } else {
                this.capBindingRegion.stepInTime(d);
            }
        }
        if (this.lacOperator != null) {
            if (this.lacOperator.getExistenceStrength() == 0.0) {
                this.lacOperator.removeFromModel();
                this.lacOperator = null;
            } else {
                this.lacOperator.stepInTime(d);
            }
        }
        if (this.lacIGene != null) {
            if (this.lacIGene.getExistenceStrength() == 0.0) {
                this.lacIGene.removeFromModel();
                this.lacIGene = null;
            } else {
                this.lacIGene.stepInTime(d);
            }
        }
        if (this.lacYGene != null) {
            if (this.lacYGene.getExistenceStrength() == 0.0) {
                this.lacYGene.removeFromModel();
                this.lacYGene = null;
            } else {
                this.lacYGene.stepInTime(d);
            }
        }
        if (this.lacZGene != null) {
            if (this.lacZGene.getExistenceStrength() == 0.0) {
                this.lacZGene.removeFromModel();
                this.lacZGene = null;
            } else {
                this.lacZGene.stepInTime(d);
            }
        }
        if (this.lacIPromoter != null) {
            if (this.lacIPromoter.getExistenceStrength() == 0.0) {
                this.lacIPromoter.removeFromModel();
                this.lacIPromoter = null;
            } else {
                this.lacIPromoter.stepInTime(d);
            }
        }
        if (this.lacPromoter != null) {
            if (this.lacPromoter.getExistenceStrength() == 0.0) {
                this.lacPromoter.removeFromModel();
                this.lacPromoter = null;
            } else {
                this.lacPromoter.stepInTime(d);
            }
        }
        if (this.automaticLactoseInjectionEnabled && this.lactoseInjectionAllowed) {
            this.automaticLactoseInjectionCountdown -= d;
            if (this.automaticLactoseInjectionCountdown <= 0.0) {
                this.createAndAddLactose(this.automaticLactoseInjectionPoint, this.automaticLactoseInjectionVelocity);
                this.automaticLactoseInjectionCountdown = 1.65;
            }
        }
    }

    private void stepElementsInTime(ArrayList<? extends IModelElement> arrayList, double d) {
        ArrayList<IModelElement> arrayList2 = new ArrayList<IModelElement>();
        for (IModelElement iModelElement : arrayList) {
            if (iModelElement.getExistenceStrength() <= 0.0) {
                arrayList2.add(iModelElement);
                continue;
            }
            iModelElement.stepInTime(d);
        }
        arrayList.removeAll(arrayList2);
        for (IModelElement iModelElement : arrayList2) {
            iModelElement.removeFromModel();
        }
    }

    private void removeElementsFromModel(ArrayList<? extends IModelElement> arrayList) {
        ArrayList<? extends IModelElement> arrayList2 = new ArrayList<IModelElement>(arrayList);
        for (IModelElement iModelElement : arrayList2) {
            arrayList.remove(iModelElement);
            iModelElement.removeFromModel();
        }
    }

    protected void notifyModelElementAdded(SimpleModelElement simpleModelElement) {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.modelElementAdded(simpleModelElement);
        }
    }

    protected void notifyLactoseInjectionAllowedStateChange() {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.lactoseInjectionAllowedStateChange();
        }
    }

    protected void notifyAutomaticLactoseInjectionEnabledStateChange() {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.automaticLactoseInjectionEnabledStateChange();
        }
    }

    protected void notifyLegendVisibilityStateChange() {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.legendVisibilityStateChange();
        }
    }

    protected void notifyLactoseMeterVisibilityStateChange() {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.lactoseMeterVisibilityStateChange();
        }
    }

    protected void notifyLactoseLevelChanged() {
        for (IGeneNetworkModelListener iGeneNetworkModelListener : this.listeners) {
            iGeneNetworkModelListener.lactoseLevelChanged();
        }
    }

    @Override
    public void addListener(IGeneNetworkModelListener iGeneNetworkModelListener) {
        if (this.listeners.contains(iGeneNetworkModelListener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(iGeneNetworkModelListener);
    }

    @Override
    public PositionWrtCell classifyPosWrtCell(Point2D point2D) {
        return PositionWrtCell.INSIDE_CELL;
    }

    @Override
    public Point2D getOpenSpotForLacY() {
        assert (false);
        return null;
    }

    @Override
    public int getLactoseLevel() {
        return this.lactoseLevel;
    }
}

