/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LacPromoter;
import edu.colorado.phet.genenetwork.model.RnaPolymerase;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LacOperator
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = new Color(200, 200, 200);
    private static final Dimension2D LAC_I_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, 1.5);
    private static final Dimension2D ATTACHMENT_REGION_SIZE = new PDimension(3.5, 1.5);
    private static double LAC_I_ATTACHMENT_TIME = 15.0;
    private LacI lacIAttachmentPartner = null;
    private AttachmentState lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private double lacIAttachmentCountdownTimer;

    public LacOperator(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D) {
        super(iGeneNetworkModelControl, LacOperator.createShape(), point2D, ELEMENT_PAINT, false, Double.POSITIVE_INFINITY);
    }

    public LacOperator(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this(iGeneNetworkModelControl, new Point2D.Double());
    }

    public LacOperator() {
        this(null, new Point2D.Double());
    }

    public void stepInTime(double d) {
        if (!this.isUserControlled()) {
            switch (this.lacIAttachmentState) {
                case UNATTACHED_AND_AVAILABLE: {
                    this.attemptToStartAttaching();
                    break;
                }
                case MOVING_TOWARDS_ATTACHMENT: {
                    this.checkAttachmentCompleted();
                    break;
                }
                case ATTACHED: {
                    this.checkTimeToDetach(d);
                    break;
                }
                case UNATTACHED_BUT_UNAVALABLE: {
                    this.checkBecomeAvailable(d);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            super.stepInTime(d);
        }
    }

    public void setDragging(boolean bl) {
        if (bl && this.lacIAttachmentPartner != null) {
            this.lacIAttachmentPartner.detach(this);
            this.lacIAttachmentPartner = null;
            this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
        super.setDragging(bl);
    }

    public boolean isLacIAttached() {
        return this.lacIAttachmentState == AttachmentState.ATTACHED;
    }

    private void attemptToStartAttaching() {
        assert (this.lacIAttachmentPartner == null);
        LacPromoter lacPromoter = this.getModel().getLacPromoter();
        if (lacPromoter != null && lacPromoter.isInContactWithRnaPolymerase()) {
            this.lacIAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        } else {
            LacI lacI = this.getModel().getNearestFreeLacI(this.getPositionRef());
            if (lacI != null && lacI.considerProposalFrom(this)) {
                this.lacIAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.lacIAttachmentPartner = lacI;
            }
        }
    }

    private void checkTimeToDetach(double d) {
        this.lacIAttachmentCountdownTimer -= d;
        if (this.lacIAttachmentCountdownTimer <= 0.0) {
            boolean bl = true;
            for (RnaPolymerase rnaPolymerase : this.getModel().getRnaPolymeraseList()) {
                if (!(rnaPolymerase.getPositionRef().distance(this.getPositionRef()) < 15.0)) continue;
                bl = false;
            }
            if (bl) {
                this.lacIAttachmentPartner.detach(this);
                this.lacIAttachmentPartner = null;
                this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            } else {
                this.lacIAttachmentCountdownTimer = 0.0;
            }
        }
    }

    private void checkBecomeAvailable(double d) {
        if (!this.getModel().getLacPromoter().isInContactWithRnaPolymerase()) {
            this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
    }

    private void checkAttachmentCompleted() {
        assert (this.lacIAttachmentPartner != null);
        LacPromoter lacPromoter = this.getModel().getLacPromoter();
        if (lacPromoter != null && lacPromoter.isInContactWithRnaPolymerase()) {
            this.lacIAttachmentPartner.detach(this);
            this.lacIAttachmentPartner = null;
            this.lacIAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        } else {
            Point2D.Double double_ = new Point2D.Double(this.getPositionRef().getX() + LAC_I_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + LAC_I_ATTACHMENT_POINT_OFFSET.getHeight());
            if (double_.distance(this.lacIAttachmentPartner.getAttachmentPointLocation(this)) < 1.0) {
                this.lacIAttachmentPartner.attach(this);
                this.lacIAttachmentState = AttachmentState.ATTACHED;
            }
            this.lacIAttachmentCountdownTimer = LAC_I_ATTACHMENT_TIME;
        }
    }

    private static Shape createShape() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(-3.5, -1.5, 7.0, 3.0 - ATTACHMENT_REGION_SIZE.getHeight());
        Rectangle2D.Double double_2 = new Rectangle2D.Double(-ATTACHMENT_REGION_SIZE.getWidth() / 2.0, double_.getMaxY(), ATTACHMENT_REGION_SIZE.getWidth(), ATTACHMENT_REGION_SIZE.getHeight());
        Area area = new Area(double_);
        area.add(new Area(double_2));
        return area;
    }

    public static Dimension2D getBindingRegionSize() {
        return ATTACHMENT_REGION_SIZE;
    }

    public Point2D getLacIAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + LAC_I_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + LAC_I_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public void detach(LacI lacI) {
        if (lacI != this.lacIAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Warning: Request to disconnect received from non-partner.");
            return;
        }
        this.lacIAttachmentPartner = null;
        this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    }

    public boolean requestImmediateAttach(LacI lacI) {
        boolean bl = false;
        if (this.lacIAttachmentState != AttachmentState.ATTACHED) {
            if (this.lacIAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT && this.lacIAttachmentPartner != lacI) {
                this.lacIAttachmentPartner.detach(this);
                this.lacIAttachmentPartner = null;
                this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            }
            if (!lacI.considerProposalFrom(this)) {
                System.err.println(this.getClass().getName() + "- Error: Proposal refused by element that requested attachment.");
                assert (false);
            }
            this.lacIAttachmentPartner = lacI;
            this.lacIAttachmentPartner.attach(this);
            this.lacIAttachmentState = AttachmentState.ATTACHED;
            this.lacIAttachmentCountdownTimer = LAC_I_ATTACHMENT_TIME;
            bl = true;
        }
        return bl;
    }

    public boolean isPartOfDnaStrand() {
        return true;
    }

    protected boolean isInAllowableLocation() {
        return this.getPositionRef().distance(this.getModel().getDnaStrand().getLacOperatorLocation()) < 5.0;
    }

    protected Point2D getDefaultLocation() {
        return this.getModel().getDnaStrand().getLacOperatorLocation();
    }
}

