/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.TransformationArrow;
import java.awt.geom.Point2D;

public class LacITransformationArrow
extends TransformationArrow {
    private final LacI lacIToAddToModel;

    public LacITransformationArrow(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, LacI lacI, double d) {
        super(iGeneNetworkModelControl, point2D, 5.0, true, d);
        this.lacIToAddToModel = lacI;
    }

    protected void onTransitionToExistingState() {
        double d = Math.cos(this.getPointingAngle()) * this.getHeadHeight() + 6.0;
        double d2 = Math.sin(this.getPointingAngle()) * this.getHeadHeight() + 4.0;
        this.lacIToAddToModel.setPosition(this.getPositionRef().getX() + d, this.getPositionRef().getY() + d2);
        this.lacIToAddToModel.setMotionStrategy(new LinearMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this.lacIToAddToModel), this.lacIToAddToModel.getPositionRef(), new Vector2D(this.getVelocityRef()), 5.0));
        this.getModel().addLacI(this.lacIToAddToModel);
    }
}

