/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.CloseOnMovingTargetMotionStrategy;
import edu.colorado.phet.genenetwork.model.DetachFromDnaThenRandomMotionWalkStrategy;
import edu.colorado.phet.genenetwork.model.DirectedRandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacOperator;
import edu.colorado.phet.genenetwork.model.Lactose;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.StillnessMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LacI
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = new Color(200, 200, 200);
    private static double WIDTH = 7.0;
    private static double HEIGHT = 4.0;
    private static PDimension LAC_OPERATOR_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, -HEIGHT / 2.0 + LacOperator.getBindingRegionSize().getHeight());
    private static PDimension GLUCOSE_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, HEIGHT / 2.0);
    private static double RECOVERY_TIME_FOR_LAC_OPERATOR_ATTACHMENT = 5.0;
    private static double RECOVERY_TIME_FOR_LACTOSE_ATTACHMENT = 2.0;
    private static final Point2D INITIAL_DESTINATION_POINT = new Point2D.Double(20.0, 0.0);
    private LacOperator lacOperatorAttachmentPartner = null;
    private AttachmentState lacOperatorAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private Glucose glucoseAttachmentPartner = null;
    private double glucoseAttachmentTimeCountdown = 0.0;
    private AttachmentState glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private Point2D targetPositionForLacOperatorAttachment = new Point2D.Double();
    private double recoveryFromLacOperatorAttachmentCountdown = 0.0;
    private double recoveryFromLactoseAttachmentCountdown = 0.0;

    public LacI(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, boolean bl) {
        super(iGeneNetworkModelControl, LacI.createActiveConformationShape(), point2D, ELEMENT_PAINT, bl, 30.0);
        if (iGeneNetworkModelControl != null) {
            this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            this.setDragBounds(this.getModel().getInteriorMotionBounds());
        }
    }

    public LacI(IGeneNetworkModelControl iGeneNetworkModelControl, boolean bl) {
        this(iGeneNetworkModelControl, new Point2D.Double(), bl);
    }

    public LacI() {
        this(null, false);
    }

    public void setDragging(boolean bl) {
        if (bl && !this.isUserControlled()) {
            if (this.lacOperatorAttachmentPartner != null) {
                assert (this.lacOperatorAttachmentState == AttachmentState.ATTACHED || this.lacOperatorAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
                this.lacOperatorAttachmentPartner.detach(this);
                this.lacOperatorAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                this.lacOperatorAttachmentPartner = null;
                this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            }
            if (this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                this.glucoseAttachmentPartner.detach(this);
                this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                this.glucoseAttachmentPartner = null;
                this.glucoseAttachmentTimeCountdown = 0.0;
            }
            if (this.glucoseAttachmentPartner == null && this.lacOperatorAttachmentPartner == null) {
                this.setOkayToFade(true);
            }
        } else if (!bl && this.isUserControlled()) {
            this.lacOperatorAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            LacOperator lacOperator = this.getModel().getLacOperator();
            if (lacOperator != null && this.glucoseAttachmentState != AttachmentState.ATTACHED && this.getPositionRef().distance(lacOperator.getPositionRef()) < 8.0) {
                lacOperator.requestImmediateAttach(this);
            } else if (this.glucoseAttachmentPartner == null) {
                this.checkForNearbyLactoseToGrab();
            }
        }
        super.setDragging(bl);
    }

    public boolean requestImmediateAttach(Glucose glucose) {
        assert (glucose != this.glucoseAttachmentPartner);
        if (this.glucoseAttachmentState == AttachmentState.ATTACHED) {
            return false;
        }
        if (this.glucoseAttachmentPartner != null) {
            this.glucoseAttachmentPartner.detach(this);
        }
        if (!glucose.considerProposalFrom(this)) {
            System.err.println(this.getClass().getName() + "- Error: Proposal refused by element that requested attachment.");
            assert (false);
        }
        this.glucoseAttachmentPartner = glucose;
        this.completeAttachmentOfGlucose();
        return true;
    }

    protected void onTransitionToExistingState() {
        this.setMotionStrategy(new DirectedRandomWalkMotionStrategy(this.getModel().getInteriorMotionBoundsAboveDna(), INITIAL_DESTINATION_POINT));
    }

    public void detach(Glucose glucose) {
        assert (glucose == this.glucoseAttachmentPartner);
        assert (this.glucoseAttachmentState == AttachmentState.ATTACHED || this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
        this.glucoseAttachmentPartner = null;
        this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        this.recoveryFromLactoseAttachmentCountdown = RECOVERY_TIME_FOR_LACTOSE_ATTACHMENT;
        this.setShape(LacI.createActiveConformationShape());
        this.setOkayToFade(true);
    }

    private static Shape createActiveConformationShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, (float)HEIGHT / 2.0f);
        generalPath.quadTo((float)WIDTH / 2.0f, (float)HEIGHT / 2.0f, (float)WIDTH / 2.0f, -((float)HEIGHT) / 2.0f);
        generalPath.lineTo((float)(-WIDTH) / 2.0f, (float)(-HEIGHT) / 2.0f);
        generalPath.lineTo((float)(-WIDTH) / 2.0f, (float)(HEIGHT * 0.25));
        generalPath.closePath();
        Area area = new Area(generalPath);
        Shape shape = Lactose.getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(0.0, HEIGHT / 2.0);
        shape = affineTransform.createTransformedShape(shape);
        Dimension2D dimension2D = LacOperator.getBindingRegionSize();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-dimension2D.getWidth() / 2.0, -HEIGHT / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        area.subtract(new Area(shape));
        area.subtract(new Area(double_));
        return area;
    }

    private static Shape createInactiveConformationShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, (float)HEIGHT / 2.0f);
        generalPath.quadTo((float)WIDTH / 2.0f, (float)HEIGHT / 2.0f, (float)WIDTH / 2.0f, -((float)HEIGHT) / 3.0f);
        generalPath.quadTo(0.0f, (float)(-HEIGHT * 0.8), (float)(-WIDTH) / 2.0f, (float)(-HEIGHT) / 3.0f);
        generalPath.lineTo((float)(-WIDTH) / 2.0f, (float)(HEIGHT * 0.25));
        generalPath.closePath();
        Area area = new Area(generalPath);
        Shape shape = Lactose.getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(0.0, HEIGHT / 2.0);
        shape = affineTransform.createTransformedShape(shape);
        area.subtract(new Area(shape));
        return area;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (!this.isUserControlled()) {
            this.updateAttachements(d);
            Point2D point2D = this.getMotionStrategyRef().getDestinationRef();
            if (point2D != null && point2D.getX() == INITIAL_DESTINATION_POINT.getX() && point2D.getY() == INITIAL_DESTINATION_POINT.getY() && point2D.distance(this.getPositionRef()) < 4.0) {
                this.getMotionStrategyRef().setDestination(null);
            }
        }
    }

    private void updateAttachements(double d) {
        if (this.lacOperatorAttachmentState == AttachmentState.UNATTACHED_BUT_UNAVALABLE && this.recoveryFromLacOperatorAttachmentCountdown != Double.POSITIVE_INFINITY) {
            this.recoveryFromLacOperatorAttachmentCountdown -= d;
            if (this.recoveryFromLacOperatorAttachmentCountdown <= 0.0) {
                this.lacOperatorAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            }
        }
        if (this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING) {
            switch (this.glucoseAttachmentState) {
                case UNATTACHED_AND_AVAILABLE: {
                    this.glucoseAttachmentPartner = this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.INSIDE_CELL, true);
                    if (this.glucoseAttachmentPartner == null) break;
                    if (!this.glucoseAttachmentPartner.considerProposalFrom(this)) {
                        assert (false);
                        break;
                    }
                    this.glucoseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                    this.setOkayToFade(false);
                    if (this.lacOperatorAttachmentPartner != null) break;
                    PDimension pDimension = new PDimension(Glucose.getLacZAttachmentPointOffset().getWidth() - LacI.getGlucoseAttachmentPointOffset().getWidth(), Glucose.getLacZAttachmentPointOffset().getHeight() - LacI.getGlucoseAttachmentPointOffset().getHeight());
                    this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(this.glucoseAttachmentPartner, pDimension, this.getModel().getInteriorMotionBoundsAboveDna()));
                    break;
                }
                case MOVING_TOWARDS_ATTACHMENT: {
                    if (!(this.getGlucoseAttachmentPointLocation().distance(this.glucoseAttachmentPartner.getLacZAttachmentPointLocation()) < 1.0)) break;
                    this.completeAttachmentOfGlucose();
                    break;
                }
                case ATTACHED: {
                    this.glucoseAttachmentTimeCountdown -= d;
                    if (!(this.glucoseAttachmentTimeCountdown <= 0.0) || this.getExistenceTimeCountdown() != 0.0 && this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.INSIDE_CELL, true) != null) break;
                    this.glucoseAttachmentPartner.detach(this);
                    this.glucoseAttachmentPartner = null;
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                    this.recoveryFromLactoseAttachmentCountdown = RECOVERY_TIME_FOR_LACTOSE_ATTACHMENT;
                    this.setShape(LacI.createActiveConformationShape());
                    this.setOkayToFade(true);
                    break;
                }
                case UNATTACHED_BUT_UNAVALABLE: {
                    this.recoveryFromLactoseAttachmentCountdown -= d;
                    if (!(this.recoveryFromLactoseAttachmentCountdown <= 0.0) || this.getExistenceState() != SimpleModelElement.ExistenceState.EXISTING) break;
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                }
            }
        }
    }

    public Point2D getGlucoseAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public static Dimension2D getGlucoseAttachmentPointOffset() {
        return new PDimension(GLUCOSE_ATTACHMENT_POINT_OFFSET);
    }

    public boolean considerProposalFrom(LacOperator lacOperator) {
        boolean bl = false;
        if (this.lacOperatorAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING && this.glucoseAttachmentPartner == null) {
            assert (this.lacOperatorAttachmentPartner == null);
            this.lacOperatorAttachmentPartner = lacOperator;
            this.lacOperatorAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
            bl = true;
            this.setOkayToFade(false);
            double d = this.lacOperatorAttachmentPartner.getLacIAttachmentPointLocation().getX() - LAC_OPERATOR_ATTACHMENT_POINT_OFFSET.getWidth();
            double d2 = this.lacOperatorAttachmentPartner.getLacIAttachmentPointLocation().getY() - LAC_OPERATOR_ATTACHMENT_POINT_OFFSET.getHeight();
            this.setMotionStrategy(new DirectedRandomWalkMotionStrategy(this.getModel().getInteriorMotionBounds(), new Point2D.Double(d, d2)));
            this.targetPositionForLacOperatorAttachment.setLocation(d, d2);
        }
        return bl;
    }

    public boolean isAvailableForAttaching() {
        return this.lacOperatorAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && !this.isUserControlled();
    }

    public void attach(LacOperator lacOperator) {
        if (lacOperator != this.lacOperatorAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Finalize request from non-partner.");
            assert (false);
            return;
        }
        this.setMotionStrategy(new StillnessMotionStrategy());
        this.setPosition(this.targetPositionForLacOperatorAttachment);
        this.lacOperatorAttachmentState = AttachmentState.ATTACHED;
    }

    public Point2D getAttachmentPointLocation(LacOperator lacOperator) {
        return new Point2D.Double(this.getPositionRef().getX() + LAC_OPERATOR_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + LAC_OPERATOR_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public void detach(LacOperator lacOperator) {
        if (lacOperator != this.lacOperatorAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Warning: Request to disconnect received from non-partner.");
            return;
        }
        this.lacOperatorAttachmentPartner = null;
        this.lacOperatorAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        this.recoveryFromLacOperatorAttachmentCountdown = RECOVERY_TIME_FOR_LAC_OPERATOR_ATTACHMENT;
        if (this.glucoseAttachmentPartner == null) {
            this.setOkayToFade(true);
            this.setMotionStrategy(new DetachFromDnaThenRandomMotionWalkStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), 0.0, null, -1.0));
        } else {
            PDimension pDimension = new PDimension(Glucose.getLacZAttachmentPointOffset().getWidth() - LacI.getGlucoseAttachmentPointOffset().getWidth(), Glucose.getLacZAttachmentPointOffset().getHeight() - LacI.getGlucoseAttachmentPointOffset().getHeight());
            this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(this.glucoseAttachmentPartner, pDimension, this.getModel().getInteriorMotionBounds()));
        }
    }

    private void completeAttachmentOfGlucose() {
        this.glucoseAttachmentPartner.attach(this);
        this.glucoseAttachmentState = AttachmentState.ATTACHED;
        this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
        this.setShape(LacI.createInactiveConformationShape());
        if (this.lacOperatorAttachmentPartner != null) {
            this.lacOperatorAttachmentPartner.detach(this);
            this.lacOperatorAttachmentPartner = null;
            this.lacOperatorAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            this.setMotionStrategy(new DetachFromDnaThenRandomMotionWalkStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), 0.0, null, -1.0));
        }
        this.setOkayToFade(false);
        this.glucoseAttachmentTimeCountdown = 15.0;
    }

    private void checkForNearbyLactoseToGrab() {
        assert (this.glucoseAttachmentPartner == null);
        Glucose glucose = this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.INSIDE_CELL, false);
        if (glucose != null && glucose.getPositionRef().distance(this.getPositionRef()) < 15.0 && glucose.breakOffPendingAttachments(this)) {
            this.glucoseAttachmentPartner = glucose;
            this.getEngagedToLactose();
            if (glucose.getPositionRef().distance(this.getPositionRef()) < 7.0) {
                this.completeAttachmentOfGlucose();
            }
        }
    }

    private void getEngagedToLactose() {
        if (this.glucoseAttachmentPartner != null) {
            if (!this.glucoseAttachmentPartner.considerProposalFrom(this)) {
                assert (false);
            } else {
                this.glucoseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.setOkayToFade(false);
                PDimension pDimension = new PDimension(Glucose.getLacZAttachmentPointOffset().getWidth() - LacI.getGlucoseAttachmentPointOffset().getWidth(), Glucose.getLacZAttachmentPointOffset().getHeight() - LacI.getGlucoseAttachmentPointOffset().getHeight());
                this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(this.glucoseAttachmentPartner, pDimension, this.getModel().getInteriorMotionBounds()));
            }
        }
    }
}

