/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AbstractMotionStrategy;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class InjectionMotionStrategy
extends AbstractMotionStrategy {
    private static final Random RAND = new Random();
    private double preRandomWalkCountdown = 4.0;
    private RandomWalkMotionStrategy randomWalkMotionStrategy;
    private final Vector2D initialVelocity = new Vector2D();
    private boolean initialVelocitySet = false;

    public InjectionMotionStrategy(Rectangle2D rectangle2D, Vector2D vector2D) {
        super(rectangle2D);
        this.initialVelocity.setComponents(vector2D.getX(), vector2D.getY());
        this.randomWalkMotionStrategy = new RandomWalkMotionStrategy(rectangle2D);
    }

    public void updatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        if (!this.initialVelocitySet) {
            simpleModelElement.setVelocity(this.initialVelocity);
            this.initialVelocitySet = true;
        }
        Point2D point2D = simpleModelElement.getPositionRef();
        Vector2D vector2D = simpleModelElement.getVelocityRef();
        if (this.preRandomWalkCountdown > 0.0) {
            if (point2D.getX() > this.getBounds().getMaxX() && vector2D.getX() > 0.0 || point2D.getX() < this.getBounds().getMinX() && vector2D.getX() < 0.0 || point2D.getY() > this.getBounds().getMaxY() && vector2D.getY() > 0.0 || point2D.getY() < this.getBounds().getMinY() && vector2D.getY() < 0.0) {
                if (point2D.getX() > this.getBounds().getMaxX() && vector2D.getX() > 0.0 || point2D.getX() < this.getBounds().getMinX() && vector2D.getX() < 0.0) {
                    vector2D.setComponents(-vector2D.getX(), vector2D.getY());
                }
                if (point2D.getY() > this.getBounds().getMaxY() && vector2D.getY() > 0.0 || point2D.getY() < this.getBounds().getMinY() && vector2D.getY() < 0.0) {
                    vector2D.setComponents(vector2D.getX(), -vector2D.getY());
                }
            } else if (RAND.nextDouble() > 0.9 + 0.1 * (this.preRandomWalkCountdown / 4.0)) {
                vector2D.rotate(RAND.nextDouble() * Math.PI / 4.0);
            }
            if (simpleModelElement.getVelocityRef().getMagnitude() > 0.0) {
                simpleModelElement.setPosition(simpleModelElement.getPositionRef().getX() + simpleModelElement.getVelocityRef().getX() * d, simpleModelElement.getPositionRef().getY() + simpleModelElement.getVelocityRef().getY() * d);
                vector2D.scale(1.0 - 0.3 * d);
            }
            this.preRandomWalkCountdown -= d;
        } else {
            this.randomWalkMotionStrategy.doUpdatePositionAndMotion(d, simpleModelElement);
        }
    }
}

