/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.CloseOnMovingTargetMotionStrategy;
import edu.colorado.phet.genenetwork.model.DirectedRandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.FollowTheLeaderMotionStrategy;
import edu.colorado.phet.genenetwork.model.Galactose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.LacZ;
import edu.colorado.phet.genenetwork.model.LinearThenRandomMotionStrategy;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.SimpleSugar;
import edu.colorado.phet.genenetwork.model.StillnessMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Glucose
extends SimpleSugar {
    private static final Dimension2D ATTACHMENT_POINT_OFFSET = new PDimension(Glucose.getWidth() / 2.0, 0.0);
    private Galactose galactoseAttachmentPartner;
    private LacZ lacZAttachmentPartner;
    private AttachmentState lacZAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
    private LacI lacIAttachmentPartner;
    private AttachmentState lacIAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
    private LacY lacYAttachmentPartner;
    private AttachmentState lacYAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
    private double holdoffPriorToFirstAttachmentCountdown = 2.0;
    private double postAttachmentRecoveryCountdown = 1.0;

    public Glucose(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D) {
        super(iGeneNetworkModelControl, point2D, Color.BLUE);
    }

    public Glucose(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this(iGeneNetworkModelControl, new Point2D.Double());
    }

    public Glucose() {
        this(null);
    }

    public static Dimension2D getGalactoseAttachmentPointOffset() {
        return new PDimension(ATTACHMENT_POINT_OFFSET);
    }

    public static Dimension2D getLacZAttachmentPointOffset() {
        return new PDimension(ATTACHMENT_POINT_OFFSET);
    }

    public static Dimension2D getLacIAttachmentPointOffset() {
        return new PDimension(ATTACHMENT_POINT_OFFSET);
    }

    public void formLactose(Galactose galactose) {
        assert (this.galactoseAttachmentPartner == null);
        this.galactoseAttachmentPartner = galactose;
        this.galactoseAttachmentPartner.attach(this);
    }

    public boolean isAvailableForAttaching() {
        return this.lacZAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.lacIAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.lacYAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE;
    }

    public boolean isBoundToGalactose() {
        return this.galactoseAttachmentPartner != null;
    }

    public boolean considerProposalFrom(LacZ lacZ) {
        boolean bl = false;
        if (this.lacZAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING) {
            assert (this.lacZAttachmentPartner == null);
            this.lacZAttachmentPartner = lacZ;
            this.lacZAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
            bl = true;
            PDimension pDimension = new PDimension(LacZ.getGlucoseAttachmentPointOffset().getWidth() - Glucose.getLacZAttachmentPointOffset().getWidth(), LacZ.getGlucoseAttachmentPointOffset().getHeight() - Glucose.getLacZAttachmentPointOffset().getHeight());
            this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(lacZ, pDimension, MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBounds(), this)));
        }
        return bl;
    }

    public boolean considerProposalFrom(LacI lacI) {
        boolean bl = false;
        if (this.lacIAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING) {
            assert (this.lacIAttachmentPartner == null);
            this.lacIAttachmentPartner = lacI;
            this.lacIAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
            bl = true;
            PDimension pDimension = new PDimension(LacI.getGlucoseAttachmentPointOffset().getWidth() - Glucose.getLacIAttachmentPointOffset().getWidth(), LacI.getGlucoseAttachmentPointOffset().getHeight() - Glucose.getLacIAttachmentPointOffset().getHeight());
            this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(lacI, pDimension, MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBounds(), this)));
        }
        return bl;
    }

    public boolean considerProposalFrom(LacY lacY) {
        boolean bl = false;
        if (this.lacYAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING) {
            assert (this.lacYAttachmentPartner == null);
            this.lacYAttachmentPartner = lacY;
            this.lacYAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
            bl = true;
            this.setMotionStrategy(new DirectedRandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getExteriorMotionBounds(), this), lacY.getGlucoseAttachmentPointLocation()));
        }
        return bl;
    }

    public void attach(LacZ lacZ) {
        if (lacZ != this.lacZAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Attach request from non-partner.");
            assert (false);
            return;
        }
        this.setPosition(lacZ.getGlucoseAttachmentPointLocation().getX() - ATTACHMENT_POINT_OFFSET.getWidth(), lacZ.getGlucoseAttachmentPointLocation().getY() - ATTACHMENT_POINT_OFFSET.getHeight());
        PDimension pDimension = new PDimension(LacZ.getGlucoseAttachmentPointOffset().getWidth() - ATTACHMENT_POINT_OFFSET.getWidth(), LacZ.getGlucoseAttachmentPointOffset().getHeight() - ATTACHMENT_POINT_OFFSET.getHeight());
        this.setMotionStrategy(new FollowTheLeaderMotionStrategy(this, lacZ, pDimension));
        this.lacZAttachmentState = AttachmentState.ATTACHED;
    }

    public void attach(LacI lacI) {
        if (lacI != this.lacIAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Attach request from non-partner.");
            assert (false);
            return;
        }
        this.setPosition(lacI.getGlucoseAttachmentPointLocation().getX() - ATTACHMENT_POINT_OFFSET.getWidth(), lacI.getGlucoseAttachmentPointLocation().getY() - ATTACHMENT_POINT_OFFSET.getHeight());
        PDimension pDimension = new PDimension(LacI.getGlucoseAttachmentPointOffset().getWidth() - ATTACHMENT_POINT_OFFSET.getWidth(), LacI.getGlucoseAttachmentPointOffset().getHeight() - ATTACHMENT_POINT_OFFSET.getHeight());
        this.setMotionStrategy(new FollowTheLeaderMotionStrategy(this, lacI, pDimension));
        this.lacIAttachmentState = AttachmentState.ATTACHED;
    }

    public void attach(LacY lacY) {
        if (lacY != this.lacYAttachmentPartner) {
            System.err.println(this.getClass().getName() + " - Error: Attach request from non-partner.");
            assert (false);
            return;
        }
        this.setPosition(lacY.getGlucoseAttachmentPointLocation().getX() - ATTACHMENT_POINT_OFFSET.getWidth(), lacY.getGlucoseAttachmentPointLocation().getY() - ATTACHMENT_POINT_OFFSET.getHeight());
        this.setMotionStrategy(new StillnessMotionStrategy());
        this.lacYAttachmentState = AttachmentState.ATTACHED;
    }

    public void detach(LacZ lacZ) {
        assert (lacZ == this.lacZAttachmentPartner);
        this.lacZAttachmentPartner = null;
        this.setMotionStrategy(new LinearThenRandomMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), this.getPositionRef(), new Vector2D(-3.0, -8.0), 1.0));
        this.lacZAttachmentState = this.galactoseAttachmentPartner == null ? AttachmentState.UNATTACHED_BUT_UNAVALABLE : AttachmentState.UNATTACHED_AND_AVAILABLE;
    }

    public void detach(LacI lacI) {
        assert (lacI == this.lacIAttachmentPartner);
        this.lacIAttachmentPartner = null;
        if (this.lacIAttachmentState == AttachmentState.ATTACHED) {
            this.setMotionStrategy(new LinearThenRandomMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), this.getPositionRef(), new Vector2D(0.0, 8.0), 0.5));
            this.lacIAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            this.postAttachmentRecoveryCountdown = 1.0;
        } else {
            this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            this.postAttachmentRecoveryCountdown = 0.0;
        }
    }

    public void detach(LacY lacY) {
        assert (lacY == this.lacYAttachmentPartner);
        this.lacYAttachmentPartner = null;
        if (this.lacYAttachmentState == AttachmentState.ATTACHED) {
            this.setMotionStrategy(new LinearThenRandomMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this), this.getPositionRef(), new Vector2D(0.0, -8.0), 0.5));
            this.lacYAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            this.postAttachmentRecoveryCountdown = 1.0;
        } else {
            this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            this.lacYAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            this.postAttachmentRecoveryCountdown = 0.0;
        }
    }

    public void releaseGalactose() {
        if (this.galactoseAttachmentPartner == null) {
            System.err.println(this.getClass().getName() + " - Error: Told to detach galactose when not attached.");
            return;
        }
        this.galactoseAttachmentPartner.detach(this);
        this.galactoseAttachmentPartner = null;
        this.setExistenceTime(0.5);
    }

    public Point2D getLacZAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public Point2D getLacYAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public void stepInTime(double d) {
        if (this.holdoffPriorToFirstAttachmentCountdown > 0.0) {
            this.holdoffPriorToFirstAttachmentCountdown -= d;
            if (this.holdoffPriorToFirstAttachmentCountdown <= 0.0) {
                this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                this.lacZAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                this.lacYAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            }
        } else if (!(this.lacIAttachmentState != AttachmentState.UNATTACHED_BUT_UNAVALABLE && this.lacYAttachmentState != AttachmentState.UNATTACHED_BUT_UNAVALABLE || this.isUserControlled())) {
            this.postAttachmentRecoveryCountdown -= d;
            if (this.postAttachmentRecoveryCountdown <= 0.0) {
                this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                this.lacYAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            }
        }
        super.stepInTime(d);
    }

    public void setDragging(boolean bl) {
        if (bl) {
            if (this.lacIAttachmentPartner != null) {
                assert (this.lacIAttachmentState == AttachmentState.ATTACHED || this.lacIAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
                this.lacIAttachmentPartner.detach(this);
                this.lacIAttachmentPartner = null;
                this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            } else if (this.lacZAttachmentPartner != null) {
                assert (this.lacZAttachmentState == AttachmentState.ATTACHED || this.lacZAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
                this.lacZAttachmentPartner.detach(this);
                this.lacZAttachmentPartner = null;
                this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
            } else if (this.lacYAttachmentPartner != null) {
                assert (this.lacYAttachmentState == AttachmentState.ATTACHED || this.lacYAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
                this.lacYAttachmentPartner.detach(this);
                this.lacYAttachmentPartner = null;
                this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getExteriorMotionBounds(), this)));
            }
            this.lacZAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            this.lacIAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            this.lacYAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
            if (this.holdoffPriorToFirstAttachmentCountdown > 0.0) {
                this.holdoffPriorToFirstAttachmentCountdown = 0.0;
            }
        } else {
            this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            this.lacZAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            this.lacYAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
            assert (this.lacIAttachmentPartner == null);
            assert (this.lacZAttachmentPartner == null);
            assert (this.lacYAttachmentPartner == null);
            if (this.getModel().classifyPosWrtCell(this.getPositionRef()) == PositionWrtCell.INSIDE_CELL) {
                Object object;
                ArrayList<LacI> arrayList = this.getModel().getLacIList();
                Object object2 = arrayList.iterator();
                while (!(!object2.hasNext() || ((SimpleModelElement)(object = object2.next())).getPositionRef().distance(this.getPositionRef()) < 8.0 && ((LacI)object).requestImmediateAttach(this))) {
                }
                if (this.lacIAttachmentState != AttachmentState.ATTACHED && this.lacIAttachmentState != AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                    LacZ lacZ;
                    object2 = this.getModel().getLacZList();
                    object = ((ArrayList)object2).iterator();
                    while (!(!object.hasNext() || (lacZ = (LacZ)object.next()).getPositionRef().distance(this.getPositionRef()) < 8.0 && lacZ.requestImmediateAttach(this))) {
                    }
                }
            } else {
                LacY lacY;
                ArrayList<LacY> arrayList = this.getModel().getLacYList();
                Iterator<LacY> iterator = arrayList.iterator();
                while (!(!iterator.hasNext() || (lacY = iterator.next()).getPositionRef().distance(this.getPositionRef()) < 8.0 && lacY.requestImmediateAttach(this))) {
                }
            }
        }
        super.setDragging(bl);
    }

    public boolean breakOffPendingAttachments(SimpleModelElement simpleModelElement) {
        if (this.isAvailableForAttaching()) {
            return true;
        }
        if (this.lacZAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT && this.getPositionRef().distance(simpleModelElement.getPositionRef()) < this.getPositionRef().distance(this.lacZAttachmentPartner.getPositionRef())) {
            this.lacZAttachmentPartner.detach(this);
            this.lacZAttachmentPartner = null;
            this.lacZAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
        if (this.lacIAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT && this.getPositionRef().distance(simpleModelElement.getPositionRef()) < this.getPositionRef().distance(this.lacIAttachmentPartner.getPositionRef())) {
            this.lacIAttachmentPartner.detach(this);
            this.lacIAttachmentPartner = null;
            this.lacIAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
        if (this.lacYAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT && this.getPositionRef().distance(simpleModelElement.getPositionRef()) < this.getPositionRef().distance(this.lacYAttachmentPartner.getPositionRef())) {
            this.lacYAttachmentPartner.detach(this);
            this.lacYAttachmentPartner = null;
            this.lacYAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
        }
        return this.isAvailableForAttaching();
    }

    public void setUpDraggableBounds(PositionWrtCell positionWrtCell) {
        switch (positionWrtCell) {
            case INSIDE_CELL: {
                this.setDragBounds(this.getModel().getInteriorMotionBounds());
                if (this.galactoseAttachmentPartner == null) break;
                this.galactoseAttachmentPartner.setDragBounds(this.getModel().getInteriorMotionBounds());
                break;
            }
            case OUTSIDE_CELL: {
                this.setDragBounds(this.getModel().getExteriorMotionBounds());
                if (this.galactoseAttachmentPartner == null) break;
                this.galactoseAttachmentPartner.setDragBounds(this.getModel().getExteriorMotionBounds());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

